@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * SKU of the dedicated HSM
 */
public enum class SkuName(
    public val javaValue: com.pulumi.azurenative.hardwaresecuritymodules.enums.SkuName,
) : ConvertibleToJava<com.pulumi.azurenative.hardwaresecuritymodules.enums.SkuName> {
    /**
     * The dedicated HSM is a Safenet Luna Network HSM A790 device.
     */
    SafeNet_Luna_Network_HSM_A790(com.pulumi.azurenative.hardwaresecuritymodules.enums.SkuName.SafeNet_Luna_Network_HSM_A790),

    /**
     * The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware Platform device with 1 local master key which supports up to 60 calls per second.
     */
    PayShield10K_LMK1_CPS60(com.pulumi.azurenative.hardwaresecuritymodules.enums.SkuName.PayShield10K_LMK1_CPS60),

    /**
     * The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware Platform device with 1 local master key which supports up to 250 calls per second.
     */
    PayShield10K_LMK1_CPS250(com.pulumi.azurenative.hardwaresecuritymodules.enums.SkuName.PayShield10K_LMK1_CPS250),

    /**
     * The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware Platform device with 1 local master key which supports up to 2500 calls per second.
     */
    PayShield10K_LMK1_CPS2500(com.pulumi.azurenative.hardwaresecuritymodules.enums.SkuName.PayShield10K_LMK1_CPS2500),

    /**
     * The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware Platform device with 2 local master keys which supports up to 60 calls per second.
     */
    PayShield10K_LMK2_CPS60(com.pulumi.azurenative.hardwaresecuritymodules.enums.SkuName.PayShield10K_LMK2_CPS60),

    /**
     * The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware Platform device with 2 local master keys which supports up to 250 calls per second.
     */
    PayShield10K_LMK2_CPS250(com.pulumi.azurenative.hardwaresecuritymodules.enums.SkuName.PayShield10K_LMK2_CPS250),

    /**
     * The dedicated HSM is a payShield 10K, model PS10-D, 10Gb Ethernet Hardware Platform device with 2 local master keys which supports up to 2500 calls per second.
     */
    PayShield10K_LMK2_CPS2500(com.pulumi.azurenative.hardwaresecuritymodules.enums.SkuName.PayShield10K_LMK2_CPS2500),
    ;

    override fun toJava(): com.pulumi.azurenative.hardwaresecuritymodules.enums.SkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hardwaresecuritymodules.enums.SkuName):
            SkuName = SkuName.values().first { it.javaValue == javaType }
    }
}
