@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs

import com.pulumi.azurenative.hardwaresecuritymodules.inputs.GetCloudHsmClusterPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudHsmClusterName The name of the Cloud HSM Cluster within the specified resource group. Cloud HSM Cluster names must be between 3 and 24 characters in length.
 * @property peConnectionName Name of the private endpoint connection associated with the Cloud HSM Cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCloudHsmClusterPrivateEndpointConnectionPlainArgs(
    public val cloudHsmClusterName: String,
    public val peConnectionName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.hardwaresecuritymodules.inputs.GetCloudHsmClusterPrivateEndpointConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.GetCloudHsmClusterPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.GetCloudHsmClusterPrivateEndpointConnectionPlainArgs.builder()
            .cloudHsmClusterName(cloudHsmClusterName.let({ args0 -> args0 }))
            .peConnectionName(peConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCloudHsmClusterPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetCloudHsmClusterPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var cloudHsmClusterName: String? = null

    private var peConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Cloud HSM Cluster within the specified resource group. Cloud HSM Cluster names must be between 3 and 24 characters in length.
     */
    @JvmName("lmaurovfcmngvlni")
    public suspend fun cloudHsmClusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cloudHsmClusterName = mapped
    }

    /**
     * @param value Name of the private endpoint connection associated with the Cloud HSM Cluster.
     */
    @JvmName("qwmaolhlcaynxmev")
    public suspend fun peConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peConnectionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ikctmssnhlyjekhs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCloudHsmClusterPrivateEndpointConnectionPlainArgs =
        GetCloudHsmClusterPrivateEndpointConnectionPlainArgs(
            cloudHsmClusterName = cloudHsmClusterName ?: throw PulumiNullFieldException("cloudHsmClusterName"),
            peConnectionName = peConnectionName ?: throw PulumiNullFieldException("peConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
