@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs

import com.pulumi.azurenative.hardwaresecuritymodules.inputs.NetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The network profile definition.
 * @property networkInterfaces Specifies the list of resource Ids for the network interfaces associated with the dedicated HSM.
 * @property subnet Specifies the identifier of the subnet.
 */
public data class NetworkProfileArgs(
    public val networkInterfaces: Output<List<NetworkInterfaceArgs>>? = null,
    public val subnet: Output<ApiEntityReferenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hardwaresecuritymodules.inputs.NetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hardwaresecuritymodules.inputs.NetworkProfileArgs =
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.NetworkProfileArgs.builder()
            .networkInterfaces(
                networkInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [NetworkProfileArgs].
 */
@PulumiTagMarker
public class NetworkProfileArgsBuilder internal constructor() {
    private var networkInterfaces: Output<List<NetworkInterfaceArgs>>? = null

    private var subnet: Output<ApiEntityReferenceArgs>? = null

    /**
     * @param value Specifies the list of resource Ids for the network interfaces associated with the dedicated HSM.
     */
    @JvmName("qlupgsjuygxpklai")
    public suspend fun networkInterfaces(`value`: Output<List<NetworkInterfaceArgs>>) {
        this.networkInterfaces = value
    }

    @JvmName("tjhihoixwjfyqeuv")
    public suspend fun networkInterfaces(vararg values: Output<NetworkInterfaceArgs>) {
        this.networkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values Specifies the list of resource Ids for the network interfaces associated with the dedicated HSM.
     */
    @JvmName("ygwjwwbpdiqdetrk")
    public suspend fun networkInterfaces(values: List<Output<NetworkInterfaceArgs>>) {
        this.networkInterfaces = Output.all(values)
    }

    /**
     * @param value Specifies the identifier of the subnet.
     */
    @JvmName("kwihekcrwiqgljki")
    public suspend fun subnet(`value`: Output<ApiEntityReferenceArgs>) {
        this.subnet = value
    }

    /**
     * @param value Specifies the list of resource Ids for the network interfaces associated with the dedicated HSM.
     */
    @JvmName("sqhjbngelaweexyx")
    public suspend fun networkInterfaces(`value`: List<NetworkInterfaceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Specifies the list of resource Ids for the network interfaces associated with the dedicated HSM.
     */
    @JvmName("pkddsojxbxykeves")
    public suspend
    fun networkInterfaces(argument: List<suspend NetworkInterfaceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Specifies the list of resource Ids for the network interfaces associated with the dedicated HSM.
     */
    @JvmName("cguwecbhwqrqfgba")
    public suspend fun networkInterfaces(
        vararg
        argument: suspend NetworkInterfaceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Specifies the list of resource Ids for the network interfaces associated with the dedicated HSM.
     */
    @JvmName("tgvvgyddududvodi")
    public suspend fun networkInterfaces(argument: suspend NetworkInterfaceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NetworkInterfaceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param values Specifies the list of resource Ids for the network interfaces associated with the dedicated HSM.
     */
    @JvmName("myjddwniamhaavwl")
    public suspend fun networkInterfaces(vararg values: NetworkInterfaceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param value Specifies the identifier of the subnet.
     */
    @JvmName("rkrglccwhgaxveom")
    public suspend fun subnet(`value`: ApiEntityReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Specifies the identifier of the subnet.
     */
    @JvmName("whugykxcaiwbkjbj")
    public suspend fun subnet(argument: suspend ApiEntityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ApiEntityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): NetworkProfileArgs = NetworkProfileArgs(
        networkInterfaces = networkInterfaces,
        subnet = subnet,
    )
}
