@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin

import com.pulumi.azurenative.hdinsight.ApplicationArgs.builder
import com.pulumi.azurenative.hdinsight.kotlin.inputs.ApplicationPropertiesArgs
import com.pulumi.azurenative.hdinsight.kotlin.inputs.ApplicationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The HDInsight cluster application
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2018-06-01-preview.
 * Other available API versions: 2023-04-15-preview, 2023-08-15-preview.
 * ## Example Usage
 * ### Create Application
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var application = new AzureNative.HDInsight.Application("application", new()
 *     {
 *         ApplicationName = "hue",
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ApplicationPropertiesArgs
 *         {
 *             ApplicationType = "CustomApplication",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D12_v2",
 *                         },
 *                         Name = "edgenode",
 *                         TargetInstanceCount = 1,
 *                     },
 *                 },
 *             },
 *             Errors = new() { },
 *             HttpsEndpoints = new[]
 *             {
 *                 new AzureNative.HDInsight.Inputs.ApplicationGetHttpsEndpointArgs
 *                 {
 *                     AccessModes = new[]
 *                     {
 *                         "WebPage",
 *                     },
 *                     DestinationPort = 20000,
 *                     SubDomainSuffix = "dss",
 *                 },
 *             },
 *             InstallScriptActions = new[]
 *             {
 *                 new AzureNative.HDInsight.Inputs.RuntimeScriptActionArgs
 *                 {
 *                     Name = "app-install-app1",
 *                     Parameters = "-version latest -port 20000",
 *                     Roles = new[]
 *                     {
 *                         "edgenode",
 *                     },
 *                     Uri = "https://.../install.sh",
 *                 },
 *             },
 *             UninstallScriptActions = new() { },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hdinsight.NewApplication(ctx, "application", &hdinsight.ApplicationArgs{
 * ApplicationName: pulumi.String("hue"),
 * ClusterName: pulumi.String("cluster1"),
 * Properties: hdinsight.ApplicationPropertiesResponse{
 * ApplicationType: pulumi.String("CustomApplication"),
 * ComputeProfile: interface{}{
 * Roles: hdinsight.RoleArray{
 * interface{}{
 * HardwareProfile: &hdinsight.HardwareProfileArgs{
 * VmSize: pulumi.String("Standard_D12_v2"),
 * },
 * Name: pulumi.String("edgenode"),
 * TargetInstanceCount: pulumi.Int(1),
 * },
 * },
 * },
 * Errors: hdinsight.ErrorsArray{
 * },
 * HttpsEndpoints: hdinsight.ApplicationGetHttpsEndpointArray{
 * &hdinsight.ApplicationGetHttpsEndpointArgs{
 * AccessModes: pulumi.StringArray{
 * pulumi.String("WebPage"),
 * },
 * DestinationPort: pulumi.Int(20000),
 * SubDomainSuffix: pulumi.String("dss"),
 * },
 * },
 * InstallScriptActions: hdinsight.RuntimeScriptActionArray{
 * &hdinsight.RuntimeScriptActionArgs{
 * Name: pulumi.String("app-install-app1"),
 * Parameters: pulumi.String("-version latest -port 20000"),
 * Roles: pulumi.StringArray{
 * pulumi.String("edgenode"),
 * },
 * Uri: pulumi.String("https://.../install.sh"),
 * },
 * },
 * UninstallScriptActions: hdinsight.RuntimeScriptActionArray{
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Application;
 * import com.pulumi.azurenative.hdinsight.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var application = new Application("application", ApplicationArgs.builder()
 *             .applicationName("hue")
 *             .clusterName("cluster1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("applicationType", "CustomApplication"),
 *                 Map.entry("computeProfile", Map.of("roles", Map.ofEntries(
 *                     Map.entry("hardwareProfile", Map.of("vmSize", "Standard_D12_v2")),
 *                     Map.entry("name", "edgenode"),
 *                     Map.entry("targetInstanceCount", 1)
 *                 ))),
 *                 Map.entry("errors", ),
 *                 Map.entry("httpsEndpoints", Map.ofEntries(
 *                     Map.entry("accessModes", "WebPage"),
 *                     Map.entry("destinationPort", 20000),
 *                     Map.entry("subDomainSuffix", "dss")
 *                 )),
 *                 Map.entry("installScriptActions", Map.ofEntries(
 *                     Map.entry("name", "app-install-app1"),
 *                     Map.entry("parameters", "-version latest -port 20000"),
 *                     Map.entry("roles", "edgenode"),
 *                     Map.entry("uri", "https://.../install.sh")
 *                 )),
 *                 Map.entry("uninstallScriptActions", )
 *             ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hdinsight:Application hue /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/applications/{applicationName}
 * ```
 * @property applicationName The constant value for the application name.
 * @property clusterName The name of the cluster.
 * @property properties The properties of the application.
 * @property resourceGroupName The name of the resource group.
 * @property tags The tags for the application.
 */
public data class ApplicationArgs(
    public val applicationName: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val properties: Output<ApplicationPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.ApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.ApplicationArgs =
        com.pulumi.azurenative.hdinsight.ApplicationArgs.builder()
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var applicationName: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var properties: Output<ApplicationPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The constant value for the application name.
     */
    @JvmName("mujxeowuohxvpcrb")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("qraherlsmodnnylo")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The properties of the application.
     */
    @JvmName("vmgyexrfsfywkpwn")
    public suspend fun properties(`value`: Output<ApplicationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("kkbdslbostuaxrak")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags for the application.
     */
    @JvmName("vokuhjrxpbtikbka")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The constant value for the application name.
     */
    @JvmName("oinhkjjwdlmxypht")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("pycsomjqptlhaxoe")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The properties of the application.
     */
    @JvmName("ibnjfygtcljtwlgb")
    public suspend fun properties(`value`: ApplicationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The properties of the application.
     */
    @JvmName("ismbrjmuwmpjfuhr")
    public suspend fun properties(argument: suspend ApplicationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hpywcaeqwtwjmiab")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags for the application.
     */
    @JvmName("icqipyxrqthsqgli")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags for the application.
     */
    @JvmName("orslvhnpqlrqvcdv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        applicationName = applicationName,
        clusterName = clusterName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
