@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of operating system.
 */
public enum class OSType(
    public val javaValue: com.pulumi.azurenative.hdinsight.enums.OSType,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.enums.OSType> {
    Windows(com.pulumi.azurenative.hdinsight.enums.OSType.Windows),
    Linux(com.pulumi.azurenative.hdinsight.enums.OSType.Linux),
    ;

    override fun toJava(): com.pulumi.azurenative.hdinsight.enums.OSType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.enums.OSType): OSType =
            OSType.values().first { it.javaValue == javaType }
    }
}
