@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ApplicationGetEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gets the application SSH endpoint
 * @property destinationPort The destination port to connect to.
 * @property location The location of the endpoint.
 * @property privateIPAddress The private ip address of the endpoint.
 * @property publicPort The public port to connect to.
 */
public data class ApplicationGetEndpointArgs(
    public val destinationPort: Output<Int>? = null,
    public val location: Output<String>? = null,
    public val privateIPAddress: Output<String>? = null,
    public val publicPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ApplicationGetEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.ApplicationGetEndpointArgs =
        com.pulumi.azurenative.hdinsight.inputs.ApplicationGetEndpointArgs.builder()
            .destinationPort(destinationPort?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .privateIPAddress(privateIPAddress?.applyValue({ args0 -> args0 }))
            .publicPort(publicPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGetEndpointArgs].
 */
@PulumiTagMarker
public class ApplicationGetEndpointArgsBuilder internal constructor() {
    private var destinationPort: Output<Int>? = null

    private var location: Output<String>? = null

    private var privateIPAddress: Output<String>? = null

    private var publicPort: Output<Int>? = null

    /**
     * @param value The destination port to connect to.
     */
    @JvmName("bsyggaawhyphgcax")
    public suspend fun destinationPort(`value`: Output<Int>) {
        this.destinationPort = value
    }

    /**
     * @param value The location of the endpoint.
     */
    @JvmName("urqljbboqfgexewy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The private ip address of the endpoint.
     */
    @JvmName("gkcieqfemiuwpppq")
    public suspend fun privateIPAddress(`value`: Output<String>) {
        this.privateIPAddress = value
    }

    /**
     * @param value The public port to connect to.
     */
    @JvmName("mmsksgjkhnfehlmv")
    public suspend fun publicPort(`value`: Output<Int>) {
        this.publicPort = value
    }

    /**
     * @param value The destination port to connect to.
     */
    @JvmName("dbvmxspunuclbjsw")
    public suspend fun destinationPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPort = mapped
    }

    /**
     * @param value The location of the endpoint.
     */
    @JvmName("kyeflfknixyahqvv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The private ip address of the endpoint.
     */
    @JvmName("pjnrvpaewfloosma")
    public suspend fun privateIPAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddress = mapped
    }

    /**
     * @param value The public port to connect to.
     */
    @JvmName("vrbjudiqgeebsypl")
    public suspend fun publicPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicPort = mapped
    }

    internal fun build(): ApplicationGetEndpointArgs = ApplicationGetEndpointArgs(
        destinationPort = destinationPort,
        location = location,
        privateIPAddress = privateIPAddress,
        publicPort = publicPort,
    )
}
