@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ApplicationGetHttpsEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Gets the application HTTP endpoints.
 * @property accessModes The list of access modes for the application.
 * @property destinationPort The destination port to connect to.
 * @property disableGatewayAuth The value indicates whether to disable GatewayAuth.
 * @property privateIPAddress The private ip address of the endpoint.
 * @property subDomainSuffix The subdomain suffix of the application.
 */
public data class ApplicationGetHttpsEndpointArgs(
    public val accessModes: Output<List<String>>? = null,
    public val destinationPort: Output<Int>? = null,
    public val disableGatewayAuth: Output<Boolean>? = null,
    public val privateIPAddress: Output<String>? = null,
    public val subDomainSuffix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ApplicationGetHttpsEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.ApplicationGetHttpsEndpointArgs =
        com.pulumi.azurenative.hdinsight.inputs.ApplicationGetHttpsEndpointArgs.builder()
            .accessModes(accessModes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationPort(destinationPort?.applyValue({ args0 -> args0 }))
            .disableGatewayAuth(disableGatewayAuth?.applyValue({ args0 -> args0 }))
            .privateIPAddress(privateIPAddress?.applyValue({ args0 -> args0 }))
            .subDomainSuffix(subDomainSuffix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGetHttpsEndpointArgs].
 */
@PulumiTagMarker
public class ApplicationGetHttpsEndpointArgsBuilder internal constructor() {
    private var accessModes: Output<List<String>>? = null

    private var destinationPort: Output<Int>? = null

    private var disableGatewayAuth: Output<Boolean>? = null

    private var privateIPAddress: Output<String>? = null

    private var subDomainSuffix: Output<String>? = null

    /**
     * @param value The list of access modes for the application.
     */
    @JvmName("ttmjfsbmtkcitevl")
    public suspend fun accessModes(`value`: Output<List<String>>) {
        this.accessModes = value
    }

    @JvmName("rgajlyxakjxygmpk")
    public suspend fun accessModes(vararg values: Output<String>) {
        this.accessModes = Output.all(values.asList())
    }

    /**
     * @param values The list of access modes for the application.
     */
    @JvmName("uoupxfmwltclhesg")
    public suspend fun accessModes(values: List<Output<String>>) {
        this.accessModes = Output.all(values)
    }

    /**
     * @param value The destination port to connect to.
     */
    @JvmName("hqxyvugfronqyvrx")
    public suspend fun destinationPort(`value`: Output<Int>) {
        this.destinationPort = value
    }

    /**
     * @param value The value indicates whether to disable GatewayAuth.
     */
    @JvmName("wshapruprwhetfhe")
    public suspend fun disableGatewayAuth(`value`: Output<Boolean>) {
        this.disableGatewayAuth = value
    }

    /**
     * @param value The private ip address of the endpoint.
     */
    @JvmName("fymevfpeoyfmvyoj")
    public suspend fun privateIPAddress(`value`: Output<String>) {
        this.privateIPAddress = value
    }

    /**
     * @param value The subdomain suffix of the application.
     */
    @JvmName("ympveoxhxwdpfidi")
    public suspend fun subDomainSuffix(`value`: Output<String>) {
        this.subDomainSuffix = value
    }

    /**
     * @param value The list of access modes for the application.
     */
    @JvmName("meerrasconpcftgp")
    public suspend fun accessModes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessModes = mapped
    }

    /**
     * @param values The list of access modes for the application.
     */
    @JvmName("lqxxyndvvhkhaunu")
    public suspend fun accessModes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessModes = mapped
    }

    /**
     * @param value The destination port to connect to.
     */
    @JvmName("ljdiqcdekdcfofwc")
    public suspend fun destinationPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPort = mapped
    }

    /**
     * @param value The value indicates whether to disable GatewayAuth.
     */
    @JvmName("ahrcgdruqibhcian")
    public suspend fun disableGatewayAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableGatewayAuth = mapped
    }

    /**
     * @param value The private ip address of the endpoint.
     */
    @JvmName("kgynsuqorwbalppj")
    public suspend fun privateIPAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddress = mapped
    }

    /**
     * @param value The subdomain suffix of the application.
     */
    @JvmName("nvuvtfdrlhqviusm")
    public suspend fun subDomainSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subDomainSuffix = mapped
    }

    internal fun build(): ApplicationGetHttpsEndpointArgs = ApplicationGetHttpsEndpointArgs(
        accessModes = accessModes,
        destinationPort = destinationPort,
        disableGatewayAuth = disableGatewayAuth,
        privateIPAddress = privateIPAddress,
        subDomainSuffix = subDomainSuffix,
    )
}
