@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ApplicationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The HDInsight cluster application GET response.
 * @property applicationType The application type.
 * @property computeProfile The list of roles in the cluster.
 * @property errors The list of errors.
 * @property httpsEndpoints The list of application HTTPS endpoints.
 * @property installScriptActions The list of install script actions.
 * @property privateLinkConfigurations The private link configurations.
 * @property sshEndpoints The list of application SSH endpoints.
 * @property uninstallScriptActions The list of uninstall script actions.
 */
public data class ApplicationPropertiesArgs(
    public val applicationType: Output<String>? = null,
    public val computeProfile: Output<ComputeProfileArgs>? = null,
    public val errors: Output<List<ErrorsArgs>>? = null,
    public val httpsEndpoints: Output<List<ApplicationGetHttpsEndpointArgs>>? = null,
    public val installScriptActions: Output<List<RuntimeScriptActionArgs>>? = null,
    public val privateLinkConfigurations: Output<List<PrivateLinkConfigurationArgs>>? = null,
    public val sshEndpoints: Output<List<ApplicationGetEndpointArgs>>? = null,
    public val uninstallScriptActions: Output<List<RuntimeScriptActionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ApplicationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.ApplicationPropertiesArgs =
        com.pulumi.azurenative.hdinsight.inputs.ApplicationPropertiesArgs.builder()
            .applicationType(applicationType?.applyValue({ args0 -> args0 }))
            .computeProfile(computeProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .errors(errors?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .httpsEndpoints(
                httpsEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .installScriptActions(
                installScriptActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .privateLinkConfigurations(
                privateLinkConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sshEndpoints(
                sshEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .uninstallScriptActions(
                uninstallScriptActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationPropertiesArgs].
 */
@PulumiTagMarker
public class ApplicationPropertiesArgsBuilder internal constructor() {
    private var applicationType: Output<String>? = null

    private var computeProfile: Output<ComputeProfileArgs>? = null

    private var errors: Output<List<ErrorsArgs>>? = null

    private var httpsEndpoints: Output<List<ApplicationGetHttpsEndpointArgs>>? = null

    private var installScriptActions: Output<List<RuntimeScriptActionArgs>>? = null

    private var privateLinkConfigurations: Output<List<PrivateLinkConfigurationArgs>>? = null

    private var sshEndpoints: Output<List<ApplicationGetEndpointArgs>>? = null

    private var uninstallScriptActions: Output<List<RuntimeScriptActionArgs>>? = null

    /**
     * @param value The application type.
     */
    @JvmName("elybfoigfkjsdwti")
    public suspend fun applicationType(`value`: Output<String>) {
        this.applicationType = value
    }

    /**
     * @param value The list of roles in the cluster.
     */
    @JvmName("lvgdpufayglovxki")
    public suspend fun computeProfile(`value`: Output<ComputeProfileArgs>) {
        this.computeProfile = value
    }

    /**
     * @param value The list of errors.
     */
    @JvmName("paxcqvdjutsdemfv")
    public suspend fun errors(`value`: Output<List<ErrorsArgs>>) {
        this.errors = value
    }

    @JvmName("frgnciubqgrbbhxj")
    public suspend fun errors(vararg values: Output<ErrorsArgs>) {
        this.errors = Output.all(values.asList())
    }

    /**
     * @param values The list of errors.
     */
    @JvmName("wyhwuoegphdpaggg")
    public suspend fun errors(values: List<Output<ErrorsArgs>>) {
        this.errors = Output.all(values)
    }

    /**
     * @param value The list of application HTTPS endpoints.
     */
    @JvmName("nelhqrpngqorugnf")
    public suspend fun httpsEndpoints(`value`: Output<List<ApplicationGetHttpsEndpointArgs>>) {
        this.httpsEndpoints = value
    }

    @JvmName("rpvuhcuqhlucnonp")
    public suspend fun httpsEndpoints(vararg values: Output<ApplicationGetHttpsEndpointArgs>) {
        this.httpsEndpoints = Output.all(values.asList())
    }

    /**
     * @param values The list of application HTTPS endpoints.
     */
    @JvmName("kjylqsutplmwgcyo")
    public suspend fun httpsEndpoints(values: List<Output<ApplicationGetHttpsEndpointArgs>>) {
        this.httpsEndpoints = Output.all(values)
    }

    /**
     * @param value The list of install script actions.
     */
    @JvmName("ijromkachenrknkl")
    public suspend fun installScriptActions(`value`: Output<List<RuntimeScriptActionArgs>>) {
        this.installScriptActions = value
    }

    @JvmName("pqqrxsaickomijkq")
    public suspend fun installScriptActions(vararg values: Output<RuntimeScriptActionArgs>) {
        this.installScriptActions = Output.all(values.asList())
    }

    /**
     * @param values The list of install script actions.
     */
    @JvmName("wjkrsvcisvkbugfa")
    public suspend fun installScriptActions(values: List<Output<RuntimeScriptActionArgs>>) {
        this.installScriptActions = Output.all(values)
    }

    /**
     * @param value The private link configurations.
     */
    @JvmName("dsfcxqktaxwkliig")
    public suspend
    fun privateLinkConfigurations(`value`: Output<List<PrivateLinkConfigurationArgs>>) {
        this.privateLinkConfigurations = value
    }

    @JvmName("csejmkjjgfjtokwb")
    public suspend fun privateLinkConfigurations(
        vararg
        values: Output<PrivateLinkConfigurationArgs>,
    ) {
        this.privateLinkConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The private link configurations.
     */
    @JvmName("iwxmsnlkiaologsp")
    public suspend fun privateLinkConfigurations(values: List<Output<PrivateLinkConfigurationArgs>>) {
        this.privateLinkConfigurations = Output.all(values)
    }

    /**
     * @param value The list of application SSH endpoints.
     */
    @JvmName("legjrroyrkstxona")
    public suspend fun sshEndpoints(`value`: Output<List<ApplicationGetEndpointArgs>>) {
        this.sshEndpoints = value
    }

    @JvmName("ljxxipmkoavheeok")
    public suspend fun sshEndpoints(vararg values: Output<ApplicationGetEndpointArgs>) {
        this.sshEndpoints = Output.all(values.asList())
    }

    /**
     * @param values The list of application SSH endpoints.
     */
    @JvmName("lpwwhknwpmncqxid")
    public suspend fun sshEndpoints(values: List<Output<ApplicationGetEndpointArgs>>) {
        this.sshEndpoints = Output.all(values)
    }

    /**
     * @param value The list of uninstall script actions.
     */
    @JvmName("qgcpiaskvttrjdjw")
    public suspend fun uninstallScriptActions(`value`: Output<List<RuntimeScriptActionArgs>>) {
        this.uninstallScriptActions = value
    }

    @JvmName("eqmlkgggvgftfiql")
    public suspend fun uninstallScriptActions(vararg values: Output<RuntimeScriptActionArgs>) {
        this.uninstallScriptActions = Output.all(values.asList())
    }

    /**
     * @param values The list of uninstall script actions.
     */
    @JvmName("sgxqbhqtkkrkxuim")
    public suspend fun uninstallScriptActions(values: List<Output<RuntimeScriptActionArgs>>) {
        this.uninstallScriptActions = Output.all(values)
    }

    /**
     * @param value The application type.
     */
    @JvmName("vkaduuxmgveihmsj")
    public suspend fun applicationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationType = mapped
    }

    /**
     * @param value The list of roles in the cluster.
     */
    @JvmName("twvsiwmnjeikejmv")
    public suspend fun computeProfile(`value`: ComputeProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeProfile = mapped
    }

    /**
     * @param argument The list of roles in the cluster.
     */
    @JvmName("lrkhxpuxenbavqno")
    public suspend fun computeProfile(argument: suspend ComputeProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.computeProfile = mapped
    }

    /**
     * @param value The list of errors.
     */
    @JvmName("ickxxmwqxpvosnuv")
    public suspend fun errors(`value`: List<ErrorsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errors = mapped
    }

    /**
     * @param argument The list of errors.
     */
    @JvmName("qgthuxccajagafca")
    public suspend fun errors(argument: List<suspend ErrorsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ErrorsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.errors = mapped
    }

    /**
     * @param argument The list of errors.
     */
    @JvmName("kkjbuioharbnnxmf")
    public suspend fun errors(vararg argument: suspend ErrorsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ErrorsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.errors = mapped
    }

    /**
     * @param argument The list of errors.
     */
    @JvmName("rbbgilscyelqukdj")
    public suspend fun errors(argument: suspend ErrorsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ErrorsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.errors = mapped
    }

    /**
     * @param values The list of errors.
     */
    @JvmName("iihfgpnuombgrvvt")
    public suspend fun errors(vararg values: ErrorsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.errors = mapped
    }

    /**
     * @param value The list of application HTTPS endpoints.
     */
    @JvmName("qvrubrfmoujckvui")
    public suspend fun httpsEndpoints(`value`: List<ApplicationGetHttpsEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsEndpoints = mapped
    }

    /**
     * @param argument The list of application HTTPS endpoints.
     */
    @JvmName("hnsenobfeyrowyjk")
    public suspend
    fun httpsEndpoints(argument: List<suspend ApplicationGetHttpsEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGetHttpsEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.httpsEndpoints = mapped
    }

    /**
     * @param argument The list of application HTTPS endpoints.
     */
    @JvmName("housrrggupbvaids")
    public suspend fun httpsEndpoints(
        vararg
        argument: suspend ApplicationGetHttpsEndpointArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGetHttpsEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.httpsEndpoints = mapped
    }

    /**
     * @param argument The list of application HTTPS endpoints.
     */
    @JvmName("xscqayatrqoqlniu")
    public suspend
    fun httpsEndpoints(argument: suspend ApplicationGetHttpsEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGetHttpsEndpointArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.httpsEndpoints = mapped
    }

    /**
     * @param values The list of application HTTPS endpoints.
     */
    @JvmName("daieoaxdbeyyhvnm")
    public suspend fun httpsEndpoints(vararg values: ApplicationGetHttpsEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpsEndpoints = mapped
    }

    /**
     * @param value The list of install script actions.
     */
    @JvmName("pqtgwnitfdutrljt")
    public suspend fun installScriptActions(`value`: List<RuntimeScriptActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installScriptActions = mapped
    }

    /**
     * @param argument The list of install script actions.
     */
    @JvmName("owwevpprulmccfkt")
    public suspend
    fun installScriptActions(argument: List<suspend RuntimeScriptActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuntimeScriptActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.installScriptActions = mapped
    }

    /**
     * @param argument The list of install script actions.
     */
    @JvmName("sihwbsnuuehqqhlx")
    public suspend fun installScriptActions(
        vararg
        argument: suspend RuntimeScriptActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuntimeScriptActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.installScriptActions = mapped
    }

    /**
     * @param argument The list of install script actions.
     */
    @JvmName("kqmdbugahydxcrvd")
    public suspend
    fun installScriptActions(argument: suspend RuntimeScriptActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuntimeScriptActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.installScriptActions = mapped
    }

    /**
     * @param values The list of install script actions.
     */
    @JvmName("rfujufdtgcghvhif")
    public suspend fun installScriptActions(vararg values: RuntimeScriptActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.installScriptActions = mapped
    }

    /**
     * @param value The private link configurations.
     */
    @JvmName("yapldhslfynqktev")
    public suspend fun privateLinkConfigurations(`value`: List<PrivateLinkConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param argument The private link configurations.
     */
    @JvmName("etscgmnqmsamlcld")
    public suspend
    fun privateLinkConfigurations(argument: List<suspend PrivateLinkConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateLinkConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param argument The private link configurations.
     */
    @JvmName("owisutnyasilwyfo")
    public suspend fun privateLinkConfigurations(
        vararg
        argument: suspend PrivateLinkConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateLinkConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param argument The private link configurations.
     */
    @JvmName("ymkxkfgtckdpknai")
    public suspend
    fun privateLinkConfigurations(argument: suspend PrivateLinkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateLinkConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param values The private link configurations.
     */
    @JvmName("shoamwapjjbfkeyi")
    public suspend fun privateLinkConfigurations(vararg values: PrivateLinkConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param value The list of application SSH endpoints.
     */
    @JvmName("idasjsblpfsvasnv")
    public suspend fun sshEndpoints(`value`: List<ApplicationGetEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshEndpoints = mapped
    }

    /**
     * @param argument The list of application SSH endpoints.
     */
    @JvmName("korqikpchnaavhtg")
    public suspend
    fun sshEndpoints(argument: List<suspend ApplicationGetEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGetEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sshEndpoints = mapped
    }

    /**
     * @param argument The list of application SSH endpoints.
     */
    @JvmName("ucothdbjkisirrbt")
    public suspend fun sshEndpoints(
        vararg
        argument: suspend ApplicationGetEndpointArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGetEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sshEndpoints = mapped
    }

    /**
     * @param argument The list of application SSH endpoints.
     */
    @JvmName("lwkiypemlrytlnkr")
    public suspend fun sshEndpoints(argument: suspend ApplicationGetEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ApplicationGetEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sshEndpoints = mapped
    }

    /**
     * @param values The list of application SSH endpoints.
     */
    @JvmName("qrgdsekhgtrwopia")
    public suspend fun sshEndpoints(vararg values: ApplicationGetEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sshEndpoints = mapped
    }

    /**
     * @param value The list of uninstall script actions.
     */
    @JvmName("dcwjljlddhwxddfa")
    public suspend fun uninstallScriptActions(`value`: List<RuntimeScriptActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uninstallScriptActions = mapped
    }

    /**
     * @param argument The list of uninstall script actions.
     */
    @JvmName("qwedfimlwrdopxbn")
    public suspend
    fun uninstallScriptActions(argument: List<suspend RuntimeScriptActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuntimeScriptActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.uninstallScriptActions = mapped
    }

    /**
     * @param argument The list of uninstall script actions.
     */
    @JvmName("mevlfkmnlgaewfgb")
    public suspend fun uninstallScriptActions(
        vararg
        argument: suspend RuntimeScriptActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuntimeScriptActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.uninstallScriptActions = mapped
    }

    /**
     * @param argument The list of uninstall script actions.
     */
    @JvmName("dvocqdyuomkawfwu")
    public suspend
    fun uninstallScriptActions(argument: suspend RuntimeScriptActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuntimeScriptActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.uninstallScriptActions = mapped
    }

    /**
     * @param values The list of uninstall script actions.
     */
    @JvmName("wevqmxbxnfwgfnay")
    public suspend fun uninstallScriptActions(vararg values: RuntimeScriptActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uninstallScriptActions = mapped
    }

    internal fun build(): ApplicationPropertiesArgs = ApplicationPropertiesArgs(
        applicationType = applicationType,
        computeProfile = computeProfile,
        errors = errors,
        httpsEndpoints = httpsEndpoints,
        installScriptActions = installScriptActions,
        privateLinkConfigurations = privateLinkConfigurations,
        sshEndpoints = sshEndpoints,
        uninstallScriptActions = uninstallScriptActions,
    )
}
