@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.AutoscaleTimeAndCapacityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Time and capacity request parameters
 * @property maxInstanceCount The maximum instance count of the cluster
 * @property minInstanceCount The minimum instance count of the cluster
 * @property time 24-hour time in the form xx:xx
 */
public data class AutoscaleTimeAndCapacityArgs(
    public val maxInstanceCount: Output<Int>? = null,
    public val minInstanceCount: Output<Int>? = null,
    public val time: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.AutoscaleTimeAndCapacityArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.AutoscaleTimeAndCapacityArgs =
        com.pulumi.azurenative.hdinsight.inputs.AutoscaleTimeAndCapacityArgs.builder()
            .maxInstanceCount(maxInstanceCount?.applyValue({ args0 -> args0 }))
            .minInstanceCount(minInstanceCount?.applyValue({ args0 -> args0 }))
            .time(time?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoscaleTimeAndCapacityArgs].
 */
@PulumiTagMarker
public class AutoscaleTimeAndCapacityArgsBuilder internal constructor() {
    private var maxInstanceCount: Output<Int>? = null

    private var minInstanceCount: Output<Int>? = null

    private var time: Output<String>? = null

    /**
     * @param value The maximum instance count of the cluster
     */
    @JvmName("ikietqyifynpmjsd")
    public suspend fun maxInstanceCount(`value`: Output<Int>) {
        this.maxInstanceCount = value
    }

    /**
     * @param value The minimum instance count of the cluster
     */
    @JvmName("hajpfalbnhmcvfmn")
    public suspend fun minInstanceCount(`value`: Output<Int>) {
        this.minInstanceCount = value
    }

    /**
     * @param value 24-hour time in the form xx:xx
     */
    @JvmName("uxehkctvlikmhelf")
    public suspend fun time(`value`: Output<String>) {
        this.time = value
    }

    /**
     * @param value The maximum instance count of the cluster
     */
    @JvmName("vjetypsfidxejofl")
    public suspend fun maxInstanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxInstanceCount = mapped
    }

    /**
     * @param value The minimum instance count of the cluster
     */
    @JvmName("kqoldcspqmcihujb")
    public suspend fun minInstanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minInstanceCount = mapped
    }

    /**
     * @param value 24-hour time in the form xx:xx
     */
    @JvmName("mofvfmesijbdhpoe")
    public suspend fun time(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.time = mapped
    }

    internal fun build(): AutoscaleTimeAndCapacityArgs = AutoscaleTimeAndCapacityArgs(
        maxInstanceCount = maxInstanceCount,
        minInstanceCount = minInstanceCount,
        time = time,
    )
}
