@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The cluster definition.
 * @property blueprint The link to the blueprint.
 * @property componentVersion The versions of different services in the cluster.
 * @property configurations The cluster configurations.
 * @property kind The type of cluster.
 */
public data class ClusterDefinitionArgs(
    public val blueprint: Output<String>? = null,
    public val componentVersion: Output<Map<String, String>>? = null,
    public val configurations: Output<Any>? = null,
    public val kind: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs =
        com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs.builder()
            .blueprint(blueprint?.applyValue({ args0 -> args0 }))
            .componentVersion(
                componentVersion?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .configurations(configurations?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterDefinitionArgs].
 */
@PulumiTagMarker
public class ClusterDefinitionArgsBuilder internal constructor() {
    private var blueprint: Output<String>? = null

    private var componentVersion: Output<Map<String, String>>? = null

    private var configurations: Output<Any>? = null

    private var kind: Output<String>? = null

    /**
     * @param value The link to the blueprint.
     */
    @JvmName("ifresdwmmoghjpuc")
    public suspend fun blueprint(`value`: Output<String>) {
        this.blueprint = value
    }

    /**
     * @param value The versions of different services in the cluster.
     */
    @JvmName("dxftcjmsncxmentj")
    public suspend fun componentVersion(`value`: Output<Map<String, String>>) {
        this.componentVersion = value
    }

    /**
     * @param value The cluster configurations.
     */
    @JvmName("prjsoucrebwtkcbd")
    public suspend fun configurations(`value`: Output<Any>) {
        this.configurations = value
    }

    /**
     * @param value The type of cluster.
     */
    @JvmName("yggafqtdqoigmvfd")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The link to the blueprint.
     */
    @JvmName("xnxrjjjhoycgaqhh")
    public suspend fun blueprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blueprint = mapped
    }

    /**
     * @param value The versions of different services in the cluster.
     */
    @JvmName("ibdsqkqyvbibgjed")
    public suspend fun componentVersion(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentVersion = mapped
    }

    /**
     * @param values The versions of different services in the cluster.
     */
    @JvmName("evabmfjxioyvdral")
    public fun componentVersion(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentVersion = mapped
    }

    /**
     * @param value The cluster configurations.
     */
    @JvmName("ynnyrllnyfngrmyl")
    public suspend fun configurations(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param value The type of cluster.
     */
    @JvmName("dpgehxttopxdtrpu")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    internal fun build(): ClusterDefinitionArgs = ClusterDefinitionArgs(
        blueprint = blueprint,
        componentVersion = componentVersion,
        configurations = configurations,
        kind = kind,
    )
}
