@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesNetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cluster pool network profile.
 * @property subnetId Cluster pool subnet resource id.
 */
public data class ClusterPoolResourcePropertiesNetworkProfileArgs(
    public val subnetId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesNetworkProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesNetworkProfileArgs =
        com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesNetworkProfileArgs.builder()
            .subnetId(subnetId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterPoolResourcePropertiesNetworkProfileArgs].
 */
@PulumiTagMarker
public class ClusterPoolResourcePropertiesNetworkProfileArgsBuilder internal constructor() {
    private var subnetId: Output<String>? = null

    /**
     * @param value Cluster pool subnet resource id.
     */
    @JvmName("qomnpsrbqoaryuhi")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Cluster pool subnet resource id.
     */
    @JvmName("ebllnomlqcbgroic")
    public suspend fun subnetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): ClusterPoolResourcePropertiesNetworkProfileArgs =
        ClusterPoolResourcePropertiesNetworkProfileArgs(
            subnetId = subnetId ?: throw PulumiNullFieldException("subnetId"),
        )
}
