@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.EncryptionInTransitPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The encryption-in-transit properties.
 * @property isEncryptionInTransitEnabled Indicates whether or not inter cluster node communication is encrypted in transit.
 */
public data class EncryptionInTransitPropertiesArgs(
    public val isEncryptionInTransitEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.EncryptionInTransitPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.EncryptionInTransitPropertiesArgs =
        com.pulumi.azurenative.hdinsight.inputs.EncryptionInTransitPropertiesArgs.builder()
            .isEncryptionInTransitEnabled(isEncryptionInTransitEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionInTransitPropertiesArgs].
 */
@PulumiTagMarker
public class EncryptionInTransitPropertiesArgsBuilder internal constructor() {
    private var isEncryptionInTransitEnabled: Output<Boolean>? = null

    /**
     * @param value Indicates whether or not inter cluster node communication is encrypted in transit.
     */
    @JvmName("dgosmhgkexebyuiq")
    public suspend fun isEncryptionInTransitEnabled(`value`: Output<Boolean>) {
        this.isEncryptionInTransitEnabled = value
    }

    /**
     * @param value Indicates whether or not inter cluster node communication is encrypted in transit.
     */
    @JvmName("kdvfjhbdqpykpbuh")
    public suspend fun isEncryptionInTransitEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEncryptionInTransitEnabled = mapped
    }

    internal fun build(): EncryptionInTransitPropertiesArgs = EncryptionInTransitPropertiesArgs(
        isEncryptionInTransitEnabled = isEncryptionInTransitEnabled,
    )
}
