@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.GetApplicationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationName The constant value for the application name.
 * @property clusterName The name of the cluster.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetApplicationPlainArgs(
    public val applicationName: String,
    public val clusterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.GetApplicationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.GetApplicationPlainArgs =
        com.pulumi.azurenative.hdinsight.inputs.GetApplicationPlainArgs.builder()
            .applicationName(applicationName.let({ args0 -> args0 }))
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationPlainArgsBuilder internal constructor() {
    private var applicationName: String? = null

    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The constant value for the application name.
     */
    @JvmName("lfjlsmcdqpsoenby")
    public suspend fun applicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("escsxeciyqchkybv")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("eaylbbdpgiplatdv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetApplicationPlainArgs = GetApplicationPlainArgs(
        applicationName = applicationName ?: throw PulumiNullFieldException("applicationName"),
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
