@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.VirtualNetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The virtual network properties.
 * @property id The ID of the virtual network.
 * @property subnet The name of the subnet.
 */
public data class VirtualNetworkProfileArgs(
    public val id: Output<String>? = null,
    public val subnet: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.VirtualNetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.VirtualNetworkProfileArgs =
        com.pulumi.azurenative.hdinsight.inputs.VirtualNetworkProfileArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .subnet(subnet?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkProfileArgs].
 */
@PulumiTagMarker
public class VirtualNetworkProfileArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var subnet: Output<String>? = null

    /**
     * @param value The ID of the virtual network.
     */
    @JvmName("fmkqujxjhgtlibfe")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the subnet.
     */
    @JvmName("hflfpglgfruhfmiw")
    public suspend fun subnet(`value`: Output<String>) {
        this.subnet = value
    }

    /**
     * @param value The ID of the virtual network.
     */
    @JvmName("vabpgmxcdvdifuuw")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the subnet.
     */
    @JvmName("povrrhheewxjrtsd")
    public suspend fun subnet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    internal fun build(): VirtualNetworkProfileArgs = VirtualNetworkProfileArgs(
        id = id,
        subnet = subnet,
    )
}
