@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * The load-based autoscale request parameters
 * @property maxInstanceCount The maximum instance count of the cluster
 * @property minInstanceCount The minimum instance count of the cluster
 */
public data class AutoscaleCapacityResponse(
    public val maxInstanceCount: Int? = null,
    public val minInstanceCount: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.AutoscaleCapacityResponse):
            AutoscaleCapacityResponse = AutoscaleCapacityResponse(
            maxInstanceCount = javaType.maxInstanceCount().map({ args0 -> args0 }).orElse(null),
            minInstanceCount = javaType.minInstanceCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
