@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Cluster pool log analytics profile to enable OMS agent for AKS cluster.
 * @property enabled True if log analytics is enabled for cluster pool, otherwise false.
 * @property workspaceId Log analytics workspace to associate with the OMS agent.
 */
public data class ClusterPoolResourcePropertiesResponseLogAnalyticsProfile(
    public val enabled: Boolean,
    public val workspaceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.ClusterPoolResourcePropertiesResponseLogAnalyticsProfile):
            ClusterPoolResourcePropertiesResponseLogAnalyticsProfile =
            ClusterPoolResourcePropertiesResponseLogAnalyticsProfile(
                enabled = javaType.enabled(),
                workspaceId = javaType.workspaceId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
