@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The kafka rest proxy configuration which contains AAD security group information.
 * @property clientGroupInfo The information of AAD security group.
 * @property configurationOverride The configurations that need to be overriden.
 */
public data class KafkaRestPropertiesResponse(
    public val clientGroupInfo: ClientGroupInfoResponse? = null,
    public val configurationOverride: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.KafkaRestPropertiesResponse):
            KafkaRestPropertiesResponse = KafkaRestPropertiesResponse(
            clientGroupInfo = javaType.clientGroupInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.ClientGroupInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            configurationOverride = javaType.configurationOverride().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
        )
    }
}
