@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The network properties.
 * @property privateLink Indicates whether or not private link is enabled.
 * @property resourceProviderConnection The direction for the resource provider connection.
 */
public data class NetworkPropertiesResponse(
    public val privateLink: String? = null,
    public val resourceProviderConnection: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.NetworkPropertiesResponse):
            NetworkPropertiesResponse = NetworkPropertiesResponse(
            privateLink = javaType.privateLink().map({ args0 -> args0 }).orElse(null),
            resourceProviderConnection = javaType.resourceProviderConnection().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
