@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The User Assigned Identity
 * @property clientId The client id of user assigned identity.
 * @property principalId The principal id of user assigned identity.
 * @property tenantId The tenant id of user assigned identity.
 */
public data class UserAssignedIdentityResponse(
    public val clientId: String,
    public val principalId: String,
    public val tenantId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.UserAssignedIdentityResponse):
            UserAssignedIdentityResponse = UserAssignedIdentityResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
