@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthbot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of a Azure Health Bot. The Health Bot Service is a cloud platform that empowers developers in Healthcare organizations to build and deploy their compliant, AI-powered virtual health assistants and health bots, that help them improve processes and reduce costs.
 * @property botManagementPortalLink The link.
 * @property keyVaultProperties KeyVault properties for the resource encryption.
 * @property provisioningState The provisioning state of the Azure Health Bot resource.
 */
public data class HealthBotPropertiesResponse(
    public val botManagementPortalLink: String,
    public val keyVaultProperties: KeyVaultPropertiesResponse? = null,
    public val provisioningState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.healthbot.outputs.HealthBotPropertiesResponse):
            HealthBotPropertiesResponse = HealthBotPropertiesResponse(
            botManagementPortalLink = javaType.botManagementPortalLink(),
            keyVaultProperties = javaType.keyVaultProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthbot.kotlin.outputs.KeyVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
