@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin

import com.pulumi.azurenative.healthcareapis.kotlin.outputs.AnalyticsConnectorDataLakeDataDestinationResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.AnalyticsConnectorFhirServiceDataSourceResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.AnalyticsConnectorFhirToParquetMappingResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServiceManagedIdentityResponseIdentity
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.AnalyticsConnectorDataLakeDataDestinationResponse.Companion.toKotlin as analyticsConnectorDataLakeDataDestinationResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.AnalyticsConnectorFhirServiceDataSourceResponse.Companion.toKotlin as analyticsConnectorFhirServiceDataSourceResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.AnalyticsConnectorFhirToParquetMappingResponse.Companion.toKotlin as analyticsConnectorFhirToParquetMappingResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServiceManagedIdentityResponseIdentity.Companion.toKotlin as serviceManagedIdentityResponseIdentityToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AnalyticsConnector].
 */
@PulumiTagMarker
public class AnalyticsConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AnalyticsConnectorArgs = AnalyticsConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AnalyticsConnectorArgsBuilder.() -> Unit) {
        val builder = AnalyticsConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AnalyticsConnector {
        val builtJavaResource =
            com.pulumi.azurenative.healthcareapis.AnalyticsConnector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AnalyticsConnector(builtJavaResource)
    }
}

/**
 * Analytics Connector definition.
 * Azure REST API version: 2022-10-01-preview.
 * ## Example Usage
 * ### Create or update a Analytics Connectors Service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var analyticsConnector = new AzureNative.HealthcareApis.AnalyticsConnector("analyticsConnector", new()
 *     {
 *         AnalyticsConnectorName = "exampleconnector",
 *         DataDestinationConfiguration = new AzureNative.HealthcareApis.Inputs.AnalyticsConnectorDataLakeDataDestinationArgs
 *         {
 *             DataLakeName = "exampledatalake",
 *             Type = "datalake",
 *         },
 *         DataMappingConfiguration = new AzureNative.HealthcareApis.Inputs.AnalyticsConnectorFhirToParquetMappingArgs
 *         {
 *             ExtensionSchemaReference = "acrexample.azurecr.io/blah@sha256aaa/Extension",
 *             FilterConfigurationReference = "acrexample.azurecr.io/blah@sha256xxx",
 *             Type = "fhirToParquet",
 *         },
 *         DataSourceConfiguration = new AzureNative.HealthcareApis.Inputs.AnalyticsConnectorFhirServiceDataSourceArgs
 *         {
 *             Kind = "R4",
 *             Type = "fhirservice",
 *             Url = "https://workspace-examplefhir.fhir.azurehealthcareapis.com",
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "testRG",
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := healthcareapis.NewAnalyticsConnector(ctx, "analyticsConnector", &healthcareapis.AnalyticsConnectorArgs{
 * AnalyticsConnectorName: pulumi.String("exampleconnector"),
 * DataDestinationConfiguration: interface{}{
 * DataLakeName: pulumi.String("exampledatalake"),
 * Type: pulumi.String("datalake"),
 * },
 * DataMappingConfiguration: interface{}{
 * ExtensionSchemaReference: pulumi.String("acrexample.azurecr.io/blah@sha256aaa/Extension"),
 * FilterConfigurationReference: pulumi.String("acrexample.azurecr.io/blah@sha256xxx"),
 * Type: pulumi.String("fhirToParquet"),
 * },
 * DataSourceConfiguration: interface{}{
 * Kind: pulumi.String("R4"),
 * Type: pulumi.String("fhirservice"),
 * Url: pulumi.String("https://workspace-examplefhir.fhir.azurehealthcareapis.com"),
 * },
 * Location: pulumi.String("westus"),
 * ResourceGroupName: pulumi.String("testRG"),
 * WorkspaceName: pulumi.String("workspace1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.AnalyticsConnector;
 * import com.pulumi.azurenative.healthcareapis.AnalyticsConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var analyticsConnector = new AnalyticsConnector("analyticsConnector", AnalyticsConnectorArgs.builder()
 *             .analyticsConnectorName("exampleconnector")
 *             .dataDestinationConfiguration(Map.ofEntries(
 *                 Map.entry("dataLakeName", "exampledatalake"),
 *                 Map.entry("type", "datalake")
 *             ))
 *             .dataMappingConfiguration(Map.ofEntries(
 *                 Map.entry("extensionSchemaReference", "acrexample.azurecr.io/blah@sha256aaa/Extension"),
 *                 Map.entry("filterConfigurationReference", "acrexample.azurecr.io/blah@sha256xxx"),
 *                 Map.entry("type", "fhirToParquet")
 *             ))
 *             .dataSourceConfiguration(Map.ofEntries(
 *                 Map.entry("kind", "R4"),
 *                 Map.entry("type", "fhirservice"),
 *                 Map.entry("url", "https://workspace-examplefhir.fhir.azurehealthcareapis.com")
 *             ))
 *             .location("westus")
 *             .resourceGroupName("testRG")
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthcareapis:AnalyticsConnector exampleconnector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/workspaces/{workspaceName}/analyticsconnectors/{analyticsConnectorName}
 * ```
 */
public class AnalyticsConnector internal constructor(
    override val javaResource: com.pulumi.azurenative.healthcareapis.AnalyticsConnector,
) : KotlinCustomResource(javaResource, AnalyticsConnectorMapper) {
    /**
     * Data destination configuration for Analytics Connector.
     */
    public val dataDestinationConfiguration: Output<AnalyticsConnectorDataLakeDataDestinationResponse>
        get() = javaResource.dataDestinationConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                analyticsConnectorDataLakeDataDestinationResponseToKotlin(args0)
            })
        })

    /**
     * Data mapping configuration for Analytics Connector.
     */
    public val dataMappingConfiguration: Output<AnalyticsConnectorFhirToParquetMappingResponse>
        get() = javaResource.dataMappingConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                analyticsConnectorFhirToParquetMappingResponseToKotlin(args0)
            })
        })

    /**
     * Data source for Analytics Connector.
     */
    public val dataSourceConfiguration: Output<AnalyticsConnectorFhirServiceDataSourceResponse>
        get() = javaResource.dataSourceConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                analyticsConnectorFhirServiceDataSourceResponseToKotlin(args0)
            })
        })

    /**
     * An etag associated with the resource, used for optimistic concurrency when editing it.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Setting indicating whether the service has a managed identity associated with it.
     */
    public val identity: Output<ServiceManagedIdentityResponseIdentity>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serviceManagedIdentityResponseIdentityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AnalyticsConnectorMapper : ResourceMapper<AnalyticsConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.healthcareapis.AnalyticsConnector::class == javaResource::class

    override fun map(javaResource: Resource): AnalyticsConnector = AnalyticsConnector(
        javaResource as
            com.pulumi.azurenative.healthcareapis.AnalyticsConnector,
    )
}

/**
 * @see [AnalyticsConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AnalyticsConnector].
 */
public suspend fun analyticsConnector(
    name: String,
    block: suspend AnalyticsConnectorResourceBuilder.() -> Unit,
): AnalyticsConnector {
    val builder = AnalyticsConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AnalyticsConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun analyticsConnector(name: String): AnalyticsConnector {
    val builder = AnalyticsConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
