@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin

import com.pulumi.azurenative.healthcareapis.DicomServiceArgs.builder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.CorsConfigurationArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.CorsConfigurationArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ServiceManagedIdentityIdentityArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ServiceManagedIdentityIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The description of Dicom Service
 * Azure REST API version: 2023-02-28. Prior API version in Azure Native 1.x: 2022-05-15.
 * Other available API versions: 2023-09-06, 2023-11-01.
 * ## Example Usage
 * ### Create or update a Dicom Service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dicomService = new AzureNative.HealthcareApis.DicomService("dicomService", new()
 *     {
 *         DicomServiceName = "blue",
 *         Location = "westus",
 *         ResourceGroupName = "testRG",
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewDicomService(ctx, "dicomService", &healthcareapis.DicomServiceArgs{
 * 			DicomServiceName:  pulumi.String("blue"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 			WorkspaceName:     pulumi.String("workspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.DicomService;
 * import com.pulumi.azurenative.healthcareapis.DicomServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dicomService = new DicomService("dicomService", DicomServiceArgs.builder()
 *             .dicomServiceName("blue")
 *             .location("westus")
 *             .resourceGroupName("testRG")
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthcareapis:DicomService blue /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/workspaces/{workspaceName}/dicomservices/{dicomServiceName}
 * ```
 * @property corsConfiguration Dicom Service Cors configuration.
 * @property dicomServiceName The name of DICOM Service resource.
 * @property identity Setting indicating whether the service has a managed identity associated with it.
 * @property location The resource location.
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property tags Resource tags.
 * @property workspaceName The name of workspace resource.
 */
public data class DicomServiceArgs(
    public val corsConfiguration: Output<CorsConfigurationArgs>? = null,
    public val dicomServiceName: Output<String>? = null,
    public val identity: Output<ServiceManagedIdentityIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.DicomServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.DicomServiceArgs =
        com.pulumi.azurenative.healthcareapis.DicomServiceArgs.builder()
            .corsConfiguration(corsConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dicomServiceName(dicomServiceName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DicomServiceArgs].
 */
@PulumiTagMarker
public class DicomServiceArgsBuilder internal constructor() {
    private var corsConfiguration: Output<CorsConfigurationArgs>? = null

    private var dicomServiceName: Output<String>? = null

    private var identity: Output<ServiceManagedIdentityIdentityArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Dicom Service Cors configuration.
     */
    @JvmName("klhugajjcpohvlnm")
    public suspend fun corsConfiguration(`value`: Output<CorsConfigurationArgs>) {
        this.corsConfiguration = value
    }

    /**
     * @param value The name of DICOM Service resource.
     */
    @JvmName("gawhskoyxholeqma")
    public suspend fun dicomServiceName(`value`: Output<String>) {
        this.dicomServiceName = value
    }

    /**
     * @param value Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("eqyoyfndjshnqwmh")
    public suspend fun identity(`value`: Output<ServiceManagedIdentityIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("glyrtqxbmoqwpacs")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("pcenovaselhsxvjq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("eabyktevpkytrroi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("nobrmaxqmoagqqit")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Dicom Service Cors configuration.
     */
    @JvmName("oadoogekafgarwus")
    public suspend fun corsConfiguration(`value`: CorsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.corsConfiguration = mapped
    }

    /**
     * @param argument Dicom Service Cors configuration.
     */
    @JvmName("kpqbckaykpvabllc")
    public suspend fun corsConfiguration(argument: suspend CorsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CorsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.corsConfiguration = mapped
    }

    /**
     * @param value The name of DICOM Service resource.
     */
    @JvmName("iblyfepulrrtnpvt")
    public suspend fun dicomServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dicomServiceName = mapped
    }

    /**
     * @param value Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("dqhrsuixqllecqkh")
    public suspend fun identity(`value`: ServiceManagedIdentityIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("buklwlfimxnhduqr")
    public suspend
    fun identity(argument: suspend ServiceManagedIdentityIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceManagedIdentityIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("vhabmvhmtplgstux")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("bohpseadvligddsl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ggllqtielbflrlvt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("knpngowdshjotsho")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("ewgswvukortdrfun")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): DicomServiceArgs = DicomServiceArgs(
        corsConfiguration = corsConfiguration,
        dicomServiceName = dicomServiceName,
        identity = identity,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        workspaceName = workspaceName,
    )
}
