@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin

import com.pulumi.azurenative.healthcareapis.WorkspaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Workspace resource.
 * Azure REST API version: 2023-02-28. Prior API version in Azure Native 1.x: 2022-05-15.
 * Other available API versions: 2023-09-06, 2023-11-01.
 * ## Example Usage
 * ### Create or update a workspace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.HealthcareApis.Workspace("workspace", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "testRG",
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewWorkspace(ctx, "workspace", &healthcareapis.WorkspaceArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 			WorkspaceName:     pulumi.String("workspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.Workspace;
 * import com.pulumi.azurenative.healthcareapis.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("testRG")
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthcareapis:Workspace workspace1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/workspaces/{workspaceName}
 * ```
 * @property location The resource location.
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property tags Resource tags.
 * @property workspaceName The name of workspace resource.
 */
public data class WorkspaceArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.WorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.WorkspaceArgs =
        com.pulumi.azurenative.healthcareapis.WorkspaceArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceArgs].
 */
@PulumiTagMarker
public class WorkspaceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The resource location.
     */
    @JvmName("xqggbycsodobdgsx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("tmjeivonpofafhpj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("taixobnbgcgwvocy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("uqbelifiecypwqep")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("pmvxndsnucfpsyea")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("kekntsdacnxcowvu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ysuolfadaqvwwbjx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("koklamkwihuxicti")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("jumbhglunhwdqhhd")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceArgs = WorkspaceArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        workspaceName = workspaceName,
    )
}
