@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Control permission for data plane traffic coming from public networks while private endpoint is enabled.
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.healthcareapis.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.enums.PublicNetworkAccess> {
    Enabled(com.pulumi.azurenative.healthcareapis.enums.PublicNetworkAccess.Enabled),
    Disabled(com.pulumi.azurenative.healthcareapis.enums.PublicNetworkAccess.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.healthcareapis.enums.PublicNetworkAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.enums.PublicNetworkAccess):
            PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
