@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.AnalyticsConnectorFhirServiceDataSourceArgs.builder
import com.pulumi.azurenative.healthcareapis.kotlin.enums.FhirServiceVersion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The FHIR service data source for Analytics Connector.
 * @property kind The kind of FHIR Service.
 * @property type Type of data source.
 * Expected value is 'fhirservice'.
 * @property url The URL of FHIR service.
 */
public data class AnalyticsConnectorFhirServiceDataSourceArgs(
    public val kind: Output<Either<String, FhirServiceVersion>>,
    public val type: Output<String>,
    public val url: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.AnalyticsConnectorFhirServiceDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.healthcareapis.inputs.AnalyticsConnectorFhirServiceDataSourceArgs =
        com.pulumi.azurenative.healthcareapis.inputs.AnalyticsConnectorFhirServiceDataSourceArgs.builder()
            .kind(
                kind.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsConnectorFhirServiceDataSourceArgs].
 */
@PulumiTagMarker
public class AnalyticsConnectorFhirServiceDataSourceArgsBuilder internal constructor() {
    private var kind: Output<Either<String, FhirServiceVersion>>? = null

    private var type: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value The kind of FHIR Service.
     */
    @JvmName("wuggvrjphhtaultg")
    public suspend fun kind(`value`: Output<Either<String, FhirServiceVersion>>) {
        this.kind = value
    }

    /**
     * @param value Type of data source.
     * Expected value is 'fhirservice'.
     */
    @JvmName("jrvndvpolqdlofts")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The URL of FHIR service.
     */
    @JvmName("ydfbhhaeksufwqed")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The kind of FHIR Service.
     */
    @JvmName("boaowtudfdpvbfjp")
    public suspend fun kind(`value`: Either<String, FhirServiceVersion>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of FHIR Service.
     */
    @JvmName("tthohvttqjbbhkxa")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FhirServiceVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of FHIR Service.
     */
    @JvmName("bvgmiliykvjoiofb")
    public fun kind(`value`: FhirServiceVersion) {
        val toBeMapped = Either.ofRight<String, FhirServiceVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Type of data source.
     * Expected value is 'fhirservice'.
     */
    @JvmName("ramiocvsxbdsawwb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The URL of FHIR service.
     */
    @JvmName("jeiyajdanajglisp")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): AnalyticsConnectorFhirServiceDataSourceArgs =
        AnalyticsConnectorFhirServiceDataSourceArgs(
            kind = kind ?: throw PulumiNullFieldException("kind"),
            type = type ?: throw PulumiNullFieldException("type"),
            url = url ?: throw PulumiNullFieldException("url"),
        )
}
