@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.FhirServiceAccessPolicyEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An access policy entry.
 * @property objectId An Azure AD object ID (User or Apps) that is allowed access to the FHIR service.
 */
public data class FhirServiceAccessPolicyEntryArgs(
    public val objectId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.FhirServiceAccessPolicyEntryArgs> {
    override fun toJava():
        com.pulumi.azurenative.healthcareapis.inputs.FhirServiceAccessPolicyEntryArgs =
        com.pulumi.azurenative.healthcareapis.inputs.FhirServiceAccessPolicyEntryArgs.builder()
            .objectId(objectId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FhirServiceAccessPolicyEntryArgs].
 */
@PulumiTagMarker
public class FhirServiceAccessPolicyEntryArgsBuilder internal constructor() {
    private var objectId: Output<String>? = null

    /**
     * @param value An Azure AD object ID (User or Apps) that is allowed access to the FHIR service.
     */
    @JvmName("awvpksbuhxsdbqoi")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value An Azure AD object ID (User or Apps) that is allowed access to the FHIR service.
     */
    @JvmName("okugiumdbsfgfvau")
    public suspend fun objectId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    internal fun build(): FhirServiceAccessPolicyEntryArgs = FhirServiceAccessPolicyEntryArgs(
        objectId = objectId ?: throw PulumiNullFieldException("objectId"),
    )
}
