@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.FhirServiceAcrConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure container registry configuration information
 * @property loginServers The list of the Azure container registry login servers.
 * @property ociArtifacts The list of Open Container Initiative (OCI) artifacts.
 */
public data class FhirServiceAcrConfigurationArgs(
    public val loginServers: Output<List<String>>? = null,
    public val ociArtifacts: Output<List<ServiceOciArtifactEntryArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.FhirServiceAcrConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.healthcareapis.inputs.FhirServiceAcrConfigurationArgs =
        com.pulumi.azurenative.healthcareapis.inputs.FhirServiceAcrConfigurationArgs.builder()
            .loginServers(loginServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ociArtifacts(
                ociArtifacts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FhirServiceAcrConfigurationArgs].
 */
@PulumiTagMarker
public class FhirServiceAcrConfigurationArgsBuilder internal constructor() {
    private var loginServers: Output<List<String>>? = null

    private var ociArtifacts: Output<List<ServiceOciArtifactEntryArgs>>? = null

    /**
     * @param value The list of the Azure container registry login servers.
     */
    @JvmName("fnqdpjsjfkjlooao")
    public suspend fun loginServers(`value`: Output<List<String>>) {
        this.loginServers = value
    }

    @JvmName("pmeemlinphgtxiin")
    public suspend fun loginServers(vararg values: Output<String>) {
        this.loginServers = Output.all(values.asList())
    }

    /**
     * @param values The list of the Azure container registry login servers.
     */
    @JvmName("xmgyxfuvbktbwtim")
    public suspend fun loginServers(values: List<Output<String>>) {
        this.loginServers = Output.all(values)
    }

    /**
     * @param value The list of Open Container Initiative (OCI) artifacts.
     */
    @JvmName("aogjwwnkmvblljys")
    public suspend fun ociArtifacts(`value`: Output<List<ServiceOciArtifactEntryArgs>>) {
        this.ociArtifacts = value
    }

    @JvmName("fownwijgwrkmqspp")
    public suspend fun ociArtifacts(vararg values: Output<ServiceOciArtifactEntryArgs>) {
        this.ociArtifacts = Output.all(values.asList())
    }

    /**
     * @param values The list of Open Container Initiative (OCI) artifacts.
     */
    @JvmName("wbpygdawwhipnfeh")
    public suspend fun ociArtifacts(values: List<Output<ServiceOciArtifactEntryArgs>>) {
        this.ociArtifacts = Output.all(values)
    }

    /**
     * @param value The list of the Azure container registry login servers.
     */
    @JvmName("aqcqtknlknqdcrni")
    public suspend fun loginServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginServers = mapped
    }

    /**
     * @param values The list of the Azure container registry login servers.
     */
    @JvmName("dkpetuqdqrsxweaf")
    public suspend fun loginServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loginServers = mapped
    }

    /**
     * @param value The list of Open Container Initiative (OCI) artifacts.
     */
    @JvmName("fvvngtrtrfjueroa")
    public suspend fun ociArtifacts(`value`: List<ServiceOciArtifactEntryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ociArtifacts = mapped
    }

    /**
     * @param argument The list of Open Container Initiative (OCI) artifacts.
     */
    @JvmName("iuwjdnvgrxmbfbee")
    public suspend
    fun ociArtifacts(argument: List<suspend ServiceOciArtifactEntryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceOciArtifactEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ociArtifacts = mapped
    }

    /**
     * @param argument The list of Open Container Initiative (OCI) artifacts.
     */
    @JvmName("numurysjwoinxwum")
    public suspend fun ociArtifacts(
        vararg
        argument: suspend ServiceOciArtifactEntryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceOciArtifactEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ociArtifacts = mapped
    }

    /**
     * @param argument The list of Open Container Initiative (OCI) artifacts.
     */
    @JvmName("kjbvejsacjcbdrtb")
    public suspend fun ociArtifacts(argument: suspend ServiceOciArtifactEntryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceOciArtifactEntryArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ociArtifacts = mapped
    }

    /**
     * @param values The list of Open Container Initiative (OCI) artifacts.
     */
    @JvmName("cqdihggxxgnmcdmc")
    public suspend fun ociArtifacts(vararg values: ServiceOciArtifactEntryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ociArtifacts = mapped
    }

    internal fun build(): FhirServiceAcrConfigurationArgs = FhirServiceAcrConfigurationArgs(
        loginServers = loginServers,
        ociArtifacts = ociArtifacts,
    )
}
