@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.GetFhirServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fhirServiceName The name of FHIR Service resource.
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property workspaceName The name of workspace resource.
 */
public data class GetFhirServicePlainArgs(
    public val fhirServiceName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.GetFhirServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.inputs.GetFhirServicePlainArgs =
        com.pulumi.azurenative.healthcareapis.inputs.GetFhirServicePlainArgs.builder()
            .fhirServiceName(fhirServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFhirServicePlainArgs].
 */
@PulumiTagMarker
public class GetFhirServicePlainArgsBuilder internal constructor() {
    private var fhirServiceName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of FHIR Service resource.
     */
    @JvmName("ljaebvefijylipjj")
    public suspend fun fhirServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fhirServiceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("kijsbjdofsjacsqp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("dvpghfjosvwmnfmx")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetFhirServicePlainArgs = GetFhirServicePlainArgs(
        fhirServiceName = fhirServiceName ?: throw PulumiNullFieldException("fhirServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
