@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.ServiceImportConfigurationInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Import operation configuration information
 * @property enabled If the import operation is enabled.
 * @property initialImportMode If the FHIR service is in InitialImportMode.
 * @property integrationDataStore The name of the default integration storage account.
 */
public data class ServiceImportConfigurationInfoArgs(
    public val enabled: Output<Boolean>? = null,
    public val initialImportMode: Output<Boolean>? = null,
    public val integrationDataStore: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.ServiceImportConfigurationInfoArgs> {
    override fun toJava():
        com.pulumi.azurenative.healthcareapis.inputs.ServiceImportConfigurationInfoArgs =
        com.pulumi.azurenative.healthcareapis.inputs.ServiceImportConfigurationInfoArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .initialImportMode(initialImportMode?.applyValue({ args0 -> args0 }))
            .integrationDataStore(integrationDataStore?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceImportConfigurationInfoArgs].
 */
@PulumiTagMarker
public class ServiceImportConfigurationInfoArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var initialImportMode: Output<Boolean>? = null

    private var integrationDataStore: Output<String>? = null

    /**
     * @param value If the import operation is enabled.
     */
    @JvmName("cyuvtyfwwoxupjhs")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value If the FHIR service is in InitialImportMode.
     */
    @JvmName("dvqackmqsugftvos")
    public suspend fun initialImportMode(`value`: Output<Boolean>) {
        this.initialImportMode = value
    }

    /**
     * @param value The name of the default integration storage account.
     */
    @JvmName("yniffhcxmohcfuyv")
    public suspend fun integrationDataStore(`value`: Output<String>) {
        this.integrationDataStore = value
    }

    /**
     * @param value If the import operation is enabled.
     */
    @JvmName("gjsxvyyutxrfxqev")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value If the FHIR service is in InitialImportMode.
     */
    @JvmName("flybglxyxebraqir")
    public suspend fun initialImportMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialImportMode = mapped
    }

    /**
     * @param value The name of the default integration storage account.
     */
    @JvmName("ecqbxdfkigqhaykh")
    public suspend fun integrationDataStore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationDataStore = mapped
    }

    internal fun build(): ServiceImportConfigurationInfoArgs = ServiceImportConfigurationInfoArgs(
        enabled = enabled,
        initialImportMode = initialImportMode,
        integrationDataStore = integrationDataStore,
    )
}
