@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.ServicesResourceIdentityArgs.builder
import com.pulumi.azurenative.healthcareapis.kotlin.enums.ManagedServiceIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Setting indicating whether the service has a managed identity associated with it.
 * @property type Type of identity being specified, currently SystemAssigned and None are allowed.
 */
public data class ServicesResourceIdentityArgs(
    public val type: Output<Either<String, ManagedServiceIdentityType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.ServicesResourceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.inputs.ServicesResourceIdentityArgs =
        com.pulumi.azurenative.healthcareapis.inputs.ServicesResourceIdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServicesResourceIdentityArgs].
 */
@PulumiTagMarker
public class ServicesResourceIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, ManagedServiceIdentityType>>? = null

    /**
     * @param value Type of identity being specified, currently SystemAssigned and None are allowed.
     */
    @JvmName("yauilisfuwgdjilv")
    public suspend fun type(`value`: Output<Either<String, ManagedServiceIdentityType>>) {
        this.type = value
    }

    /**
     * @param value Type of identity being specified, currently SystemAssigned and None are allowed.
     */
    @JvmName("fymmxbgvbfmlmysx")
    public suspend fun type(`value`: Either<String, ManagedServiceIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of identity being specified, currently SystemAssigned and None are allowed.
     */
    @JvmName("didnqsisqyweryab")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of identity being specified, currently SystemAssigned and None are allowed.
     */
    @JvmName("ymmkoucqctplehay")
    public fun type(`value`: ManagedServiceIdentityType) {
        val toBeMapped = Either.ofRight<String, ManagedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServicesResourceIdentityArgs = ServicesResourceIdentityArgs(
        type = type,
    )
}
