@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The description of Fhir Service
 * @property accessPolicies Fhir Service access policies.
 * @property acrConfiguration Fhir Service Azure container registry configuration.
 * @property authenticationConfiguration Fhir Service authentication configuration.
 * @property corsConfiguration Fhir Service Cors configuration.
 * @property etag An etag associated with the resource, used for optimistic concurrency when editing it.
 * @property eventState Fhir Service event support status.
 * @property exportConfiguration Fhir Service export configuration.
 * @property id The resource identifier.
 * @property identity Setting indicating whether the service has a managed identity associated with it.
 * @property implementationGuidesConfiguration Implementation Guides configuration.
 * @property importConfiguration Fhir Service import configuration.
 * @property kind The kind of the service.
 * @property location The resource location.
 * @property name The resource name.
 * @property privateEndpointConnections The list of private endpoint connections that are set up for this resource.
 * @property provisioningState The provisioning state.
 * @property publicNetworkAccess Control permission for data plane traffic coming from public networks while private endpoint is enabled.
 * @property resourceVersionPolicyConfiguration Determines tracking of history for resources.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type The resource type.
 */
public data class GetFhirServiceResult(
    public val accessPolicies: List<FhirServiceAccessPolicyEntryResponse>? = null,
    public val acrConfiguration: FhirServiceAcrConfigurationResponse? = null,
    public val authenticationConfiguration: FhirServiceAuthenticationConfigurationResponse? = null,
    public val corsConfiguration: FhirServiceCorsConfigurationResponse? = null,
    public val etag: String? = null,
    public val eventState: String,
    public val exportConfiguration: FhirServiceExportConfigurationResponse? = null,
    public val id: String,
    public val identity: ServiceManagedIdentityResponseIdentity? = null,
    public val implementationGuidesConfiguration: ImplementationGuidesConfigurationResponse? = null,
    public val importConfiguration: FhirServiceImportConfigurationResponse? = null,
    public val kind: String? = null,
    public val location: String? = null,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String,
    public val resourceVersionPolicyConfiguration: ResourceVersionPolicyConfigurationResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.GetFhirServiceResult):
            GetFhirServiceResult = GetFhirServiceResult(
            accessPolicies = javaType.accessPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceAccessPolicyEntryResponse.Companion.toKotlin(args0)
                })
            }),
            acrConfiguration = javaType.acrConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceAcrConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            authenticationConfiguration = javaType.authenticationConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceAuthenticationConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            corsConfiguration = javaType.corsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceCorsConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            eventState = javaType.eventState(),
            exportConfiguration = javaType.exportConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceExportConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServiceManagedIdentityResponseIdentity.Companion.toKotlin(args0)
                })
            }).orElse(null),
            implementationGuidesConfiguration = javaType.implementationGuidesConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.ImplementationGuidesConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            importConfiguration = javaType.importConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.FhirServiceImportConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess(),
            resourceVersionPolicyConfiguration = javaType.resourceVersionPolicyConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.ResourceVersionPolicyConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
