@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The settings for Implementation Guides - defining capabilities for national standards, vendor consortiums, clinical societies, etc.
 * @property usCoreMissingData If US Core Missing Data requirement is enabled.
 */
public data class ImplementationGuidesConfigurationResponse(
    public val usCoreMissingData: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.ImplementationGuidesConfigurationResponse):
            ImplementationGuidesConfigurationResponse = ImplementationGuidesConfigurationResponse(
            usCoreMissingData = javaType.usCoreMissingData().map({ args0 -> args0 }).orElse(null),
        )
    }
}
