@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin

import com.pulumi.azurenative.hybridcompute.kotlin.outputs.EsuKeyResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.EsuKeyResponse.Companion.toKotlin as esuKeyResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [LicenseProfile].
 */
@PulumiTagMarker
public class LicenseProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LicenseProfileArgs = LicenseProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LicenseProfileArgsBuilder.() -> Unit) {
        val builder = LicenseProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LicenseProfile {
        val builtJavaResource =
            com.pulumi.azurenative.hybridcompute.LicenseProfile(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LicenseProfile(builtJavaResource)
    }
}

/**
 * Describes a license profile in a hybrid machine.
 * Azure REST API version: 2023-06-20-preview.
 * Other available API versions: 2023-10-03-preview.
 * ## Example Usage
 * ### Create or Update a License Profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var licenseProfile = new AzureNative.HybridCompute.LicenseProfile("licenseProfile", new()
 *     {
 *         AssignedLicense = "{LicenseResourceId}",
 *         LicenseProfileName = "default",
 *         Location = "eastus2euap",
 *         MachineName = "myMachine",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewLicenseProfile(ctx, "licenseProfile", &hybridcompute.LicenseProfileArgs{
 * 			AssignedLicense:    pulumi.String("{LicenseResourceId}"),
 * 			LicenseProfileName: pulumi.String("default"),
 * 			Location:           pulumi.String("eastus2euap"),
 * 			MachineName:        pulumi.String("myMachine"),
 * 			ResourceGroupName:  pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.LicenseProfile;
 * import com.pulumi.azurenative.hybridcompute.LicenseProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var licenseProfile = new LicenseProfile("licenseProfile", LicenseProfileArgs.builder()
 *             .assignedLicense("{LicenseResourceId}")
 *             .licenseProfileName("default")
 *             .location("eastus2euap")
 *             .machineName("myMachine")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcompute:LicenseProfile default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/licenseProfiles/{licenseProfileName}
 * ```
 */
public class LicenseProfile internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridcompute.LicenseProfile,
) : KotlinCustomResource(javaResource, LicenseProfileMapper) {
    /**
     * The resource id of the license.
     */
    public val assignedLicense: Output<String>?
        get() = javaResource.assignedLicense().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The guid id of the license.
     */
    public val assignedLicenseImmutableId: Output<String>
        get() = javaResource.assignedLicenseImmutableId().applyValue({ args0 -> args0 })

    /**
     * Indicates the eligibility state of Esu.
     */
    public val esuEligibility: Output<String>
        get() = javaResource.esuEligibility().applyValue({ args0 -> args0 })

    /**
     * Indicates whether there is an ESU Key currently active for the machine.
     */
    public val esuKeyState: Output<String>
        get() = javaResource.esuKeyState().applyValue({ args0 -> args0 })

    /**
     * The list of ESU keys.
     */
    public val esuKeys: Output<List<EsuKeyResponse>>
        get() = javaResource.esuKeys().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    esuKeyResponseToKotlin(args0)
                })
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The type of the Esu servers.
     */
    public val serverType: Output<String>
        get() = javaResource.serverType().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LicenseProfileMapper : ResourceMapper<LicenseProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridcompute.LicenseProfile::class == javaResource::class

    override fun map(javaResource: Resource): LicenseProfile = LicenseProfile(
        javaResource as
            com.pulumi.azurenative.hybridcompute.LicenseProfile,
    )
}

/**
 * @see [LicenseProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LicenseProfile].
 */
public suspend fun licenseProfile(
    name: String,
    block: suspend LicenseProfileResourceBuilder.() -> Unit,
): LicenseProfile {
    val builder = LicenseProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LicenseProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun licenseProfile(name: String): LicenseProfile {
    val builder = LicenseProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
