@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.AgentUpgradeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The info w.r.t Agent Upgrade.
 * @property correlationId The correlation ID passed in from RSM per upgrade.
 * @property desiredVersion Specifies the version info w.r.t AgentUpgrade for the machine.
 * @property enableAutomaticUpgrade Specifies if RSM should try to upgrade this machine
 */
public data class AgentUpgradeArgs(
    public val correlationId: Output<String>? = null,
    public val desiredVersion: Output<String>? = null,
    public val enableAutomaticUpgrade: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.AgentUpgradeArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.AgentUpgradeArgs =
        com.pulumi.azurenative.hybridcompute.inputs.AgentUpgradeArgs.builder()
            .correlationId(correlationId?.applyValue({ args0 -> args0 }))
            .desiredVersion(desiredVersion?.applyValue({ args0 -> args0 }))
            .enableAutomaticUpgrade(enableAutomaticUpgrade?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentUpgradeArgs].
 */
@PulumiTagMarker
public class AgentUpgradeArgsBuilder internal constructor() {
    private var correlationId: Output<String>? = null

    private var desiredVersion: Output<String>? = null

    private var enableAutomaticUpgrade: Output<Boolean>? = null

    /**
     * @param value The correlation ID passed in from RSM per upgrade.
     */
    @JvmName("jdtbhiotqvnaxjyu")
    public suspend fun correlationId(`value`: Output<String>) {
        this.correlationId = value
    }

    /**
     * @param value Specifies the version info w.r.t AgentUpgrade for the machine.
     */
    @JvmName("evbvxrdoochbidrl")
    public suspend fun desiredVersion(`value`: Output<String>) {
        this.desiredVersion = value
    }

    /**
     * @param value Specifies if RSM should try to upgrade this machine
     */
    @JvmName("nolhnwejvwdjomhj")
    public suspend fun enableAutomaticUpgrade(`value`: Output<Boolean>) {
        this.enableAutomaticUpgrade = value
    }

    /**
     * @param value The correlation ID passed in from RSM per upgrade.
     */
    @JvmName("gnhfiunxfpxrhxlk")
    public suspend fun correlationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.correlationId = mapped
    }

    /**
     * @param value Specifies the version info w.r.t AgentUpgrade for the machine.
     */
    @JvmName("fwgduoauatymtqql")
    public suspend fun desiredVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredVersion = mapped
    }

    /**
     * @param value Specifies if RSM should try to upgrade this machine
     */
    @JvmName("xnpjirqivcdckvwi")
    public suspend fun enableAutomaticUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticUpgrade = mapped
    }

    internal fun build(): AgentUpgradeArgs = AgentUpgradeArgs(
        correlationId = correlationId,
        desiredVersion = desiredVersion,
        enableAutomaticUpgrade = enableAutomaticUpgrade,
    )
}
