@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.GetMachineExtensionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property extensionName The name of the machine extension.
 * @property machineName The name of the machine containing the extension.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetMachineExtensionPlainArgs(
    public val extensionName: String,
    public val machineName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.GetMachineExtensionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.GetMachineExtensionPlainArgs =
        com.pulumi.azurenative.hybridcompute.inputs.GetMachineExtensionPlainArgs.builder()
            .extensionName(extensionName.let({ args0 -> args0 }))
            .machineName(machineName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMachineExtensionPlainArgs].
 */
@PulumiTagMarker
public class GetMachineExtensionPlainArgsBuilder internal constructor() {
    private var extensionName: String? = null

    private var machineName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the machine extension.
     */
    @JvmName("dxpemppiuggmusvn")
    public suspend fun extensionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.extensionName = mapped
    }

    /**
     * @param value The name of the machine containing the extension.
     */
    @JvmName("ijfdonedawxjfhuw")
    public suspend fun machineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.machineName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ipfjcwgoxoyfvnde")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMachineExtensionPlainArgs = GetMachineExtensionPlainArgs(
        extensionName = extensionName ?: throw PulumiNullFieldException("extensionName"),
        machineName = machineName ?: throw PulumiNullFieldException("machineName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
