@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.MachineRunCommandScriptSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the script sources for run command. Use only one of script, scriptUri, commandId.
 * @property commandId Specifies the commandId of predefined built-in script.
 * @property script Specifies the script content to be executed on the machine.
 * @property scriptUri Specifies the script download location. It can be either SAS URI of an Azure storage blob with read access or public URI.
 * @property scriptUriManagedIdentity User-assigned managed identity that has access to scriptUri in case of Azure storage blob. Use an empty object in case of system-assigned identity. Make sure the Azure storage blob exists, and managed identity has been given access to blob's container with 'Storage Blob Data Reader' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged.
 */
public data class MachineRunCommandScriptSourceArgs(
    public val commandId: Output<String>? = null,
    public val script: Output<String>? = null,
    public val scriptUri: Output<String>? = null,
    public val scriptUriManagedIdentity: Output<RunCommandManagedIdentityArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.MachineRunCommandScriptSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcompute.inputs.MachineRunCommandScriptSourceArgs =
        com.pulumi.azurenative.hybridcompute.inputs.MachineRunCommandScriptSourceArgs.builder()
            .commandId(commandId?.applyValue({ args0 -> args0 }))
            .script(script?.applyValue({ args0 -> args0 }))
            .scriptUri(scriptUri?.applyValue({ args0 -> args0 }))
            .scriptUriManagedIdentity(
                scriptUriManagedIdentity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MachineRunCommandScriptSourceArgs].
 */
@PulumiTagMarker
public class MachineRunCommandScriptSourceArgsBuilder internal constructor() {
    private var commandId: Output<String>? = null

    private var script: Output<String>? = null

    private var scriptUri: Output<String>? = null

    private var scriptUriManagedIdentity: Output<RunCommandManagedIdentityArgs>? = null

    /**
     * @param value Specifies the commandId of predefined built-in script.
     */
    @JvmName("mtsqktaknxhqkdml")
    public suspend fun commandId(`value`: Output<String>) {
        this.commandId = value
    }

    /**
     * @param value Specifies the script content to be executed on the machine.
     */
    @JvmName("movpygyfkhxuphrx")
    public suspend fun script(`value`: Output<String>) {
        this.script = value
    }

    /**
     * @param value Specifies the script download location. It can be either SAS URI of an Azure storage blob with read access or public URI.
     */
    @JvmName("cajraabohcuttttc")
    public suspend fun scriptUri(`value`: Output<String>) {
        this.scriptUri = value
    }

    /**
     * @param value User-assigned managed identity that has access to scriptUri in case of Azure storage blob. Use an empty object in case of system-assigned identity. Make sure the Azure storage blob exists, and managed identity has been given access to blob's container with 'Storage Blob Data Reader' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged.
     */
    @JvmName("plifsegqnbgwhvmn")
    public suspend fun scriptUriManagedIdentity(`value`: Output<RunCommandManagedIdentityArgs>) {
        this.scriptUriManagedIdentity = value
    }

    /**
     * @param value Specifies the commandId of predefined built-in script.
     */
    @JvmName("pgsqqgagunvcegwj")
    public suspend fun commandId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commandId = mapped
    }

    /**
     * @param value Specifies the script content to be executed on the machine.
     */
    @JvmName("njkjoeyyvfwqvraw")
    public suspend fun script(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.script = mapped
    }

    /**
     * @param value Specifies the script download location. It can be either SAS URI of an Azure storage blob with read access or public URI.
     */
    @JvmName("qnwcosssbuffacna")
    public suspend fun scriptUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptUri = mapped
    }

    /**
     * @param value User-assigned managed identity that has access to scriptUri in case of Azure storage blob. Use an empty object in case of system-assigned identity. Make sure the Azure storage blob exists, and managed identity has been given access to blob's container with 'Storage Blob Data Reader' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged.
     */
    @JvmName("mnlbiahhvqwbowni")
    public suspend fun scriptUriManagedIdentity(`value`: RunCommandManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptUriManagedIdentity = mapped
    }

    /**
     * @param argument User-assigned managed identity that has access to scriptUri in case of Azure storage blob. Use an empty object in case of system-assigned identity. Make sure the Azure storage blob exists, and managed identity has been given access to blob's container with 'Storage Blob Data Reader' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged.
     */
    @JvmName("naaijmbduecicosa")
    public suspend
    fun scriptUriManagedIdentity(argument: suspend RunCommandManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = RunCommandManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scriptUriManagedIdentity = mapped
    }

    internal fun build(): MachineRunCommandScriptSourceArgs = MachineRunCommandScriptSourceArgs(
        commandId = commandId,
        script = script,
        scriptUri = scriptUri,
        scriptUriManagedIdentity = scriptUriManagedIdentity,
    )
}
