@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The info w.r.t Agent Upgrade.
 * @property correlationId The correlation ID passed in from RSM per upgrade.
 * @property desiredVersion Specifies the version info w.r.t AgentUpgrade for the machine.
 * @property enableAutomaticUpgrade Specifies if RSM should try to upgrade this machine
 * @property lastAttemptMessage Failure message of last upgrade attempt if any.
 * @property lastAttemptStatus Specifies the status of Agent Upgrade.
 * @property lastAttemptTimestamp Timestamp of last upgrade attempt
 */
public data class AgentUpgradeResponse(
    public val correlationId: String? = null,
    public val desiredVersion: String? = null,
    public val enableAutomaticUpgrade: Boolean? = null,
    public val lastAttemptMessage: String,
    public val lastAttemptStatus: String,
    public val lastAttemptTimestamp: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.AgentUpgradeResponse):
            AgentUpgradeResponse = AgentUpgradeResponse(
            correlationId = javaType.correlationId().map({ args0 -> args0 }).orElse(null),
            desiredVersion = javaType.desiredVersion().map({ args0 -> args0 }).orElse(null),
            enableAutomaticUpgrade = javaType.enableAutomaticUpgrade().map({ args0 -> args0 }).orElse(null),
            lastAttemptMessage = javaType.lastAttemptMessage(),
            lastAttemptStatus = javaType.lastAttemptStatus(),
            lastAttemptTimestamp = javaType.lastAttemptTimestamp(),
        )
    }
}
