@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Describes a license in a hybrid machine.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property licenseDetails Describes the properties of a License.
 * @property licenseType The type of the license resource.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property tenantId Describes the tenant id.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetLicenseResult(
    public val id: String,
    public val licenseDetails: LicenseDetailsResponse? = null,
    public val licenseType: String? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val tenantId: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.GetLicenseResult):
            GetLicenseResult = GetLicenseResult(
            id = javaType.id(),
            licenseDetails = javaType.licenseDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.LicenseDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
