@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *  Contains clientId or objectId (use only one, not both) of a user-assigned managed identity that has access to storage blob used in Run Command. Use an empty RunCommandManagedIdentity object in case of system-assigned identity. Make sure the Azure storage blob exists in case of scriptUri, and managed identity has been given access to blob's container with 'Storage Blob Data Reader' role assignment with scriptUri blob and 'Storage Blob Data Contributor' for Append blobs(outputBlobUri, errorBlobUri). In case of user assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged.
 * @property clientId Client Id (GUID value) of the user-assigned managed identity. ObjectId should not be used if this is provided.
 * @property objectId Object Id (GUID value) of the user-assigned managed identity. ClientId should not be used if this is provided.
 */
public data class RunCommandManagedIdentityResponse(
    public val clientId: String? = null,
    public val objectId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.RunCommandManagedIdentityResponse):
            RunCommandManagedIdentityResponse = RunCommandManagedIdentityResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
