@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridconnectivity.kotlin.inputs

import com.pulumi.azurenative.hybridconnectivity.inputs.ListEndpointCredentialsPlainArgs.builder
import com.pulumi.azurenative.hybridconnectivity.kotlin.enums.ServiceName
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointName The endpoint name.
 * @property expiresin The is how long the endpoint access token is valid (in seconds).
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
 * @property serviceName The name of the service. If not provided, the request will by pass the generation of service configuration token
 */
public data class ListEndpointCredentialsPlainArgs(
    public val endpointName: String,
    public val expiresin: Int? = null,
    public val resourceUri: String,
    public val serviceName: Either<String, ServiceName>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridconnectivity.inputs.ListEndpointCredentialsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridconnectivity.inputs.ListEndpointCredentialsPlainArgs =
        com.pulumi.azurenative.hybridconnectivity.inputs.ListEndpointCredentialsPlainArgs.builder()
            .endpointName(endpointName.let({ args0 -> args0 }))
            .expiresin(expiresin?.let({ args0 -> args0 }))
            .resourceUri(resourceUri.let({ args0 -> args0 }))
            .serviceName(
                serviceName?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ListEndpointCredentialsPlainArgs].
 */
@PulumiTagMarker
public class ListEndpointCredentialsPlainArgsBuilder internal constructor() {
    private var endpointName: String? = null

    private var expiresin: Int? = null

    private var resourceUri: String? = null

    private var serviceName: Either<String, ServiceName>? = null

    /**
     * @param value The endpoint name.
     */
    @JvmName("mfwjmvctgdnhocvq")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointName = mapped
    }

    /**
     * @param value The is how long the endpoint access token is valid (in seconds).
     */
    @JvmName("oaasmageahwriycd")
    public suspend fun expiresin(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expiresin = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource to be connected.
     */
    @JvmName("sgjfwlucajamhbdc")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    /**
     * @param value The name of the service. If not provided, the request will by pass the generation of service configuration token
     */
    @JvmName("ppgqfqvgvryguurg")
    public suspend fun serviceName(`value`: Either<String, ServiceName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value The name of the service. If not provided, the request will by pass the generation of service configuration token
     */
    @JvmName("peoyytbeufkmxonm")
    public fun serviceName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceName>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value The name of the service. If not provided, the request will by pass the generation of service configuration token
     */
    @JvmName("iumvjpjoiifonuql")
    public fun serviceName(`value`: ServiceName) {
        val toBeMapped = Either.ofRight<String, ServiceName>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): ListEndpointCredentialsPlainArgs = ListEndpointCredentialsPlainArgs(
        endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
        expiresin = expiresin,
        resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
        serviceName = serviceName,
    )
}
