@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridconnectivity.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Managed Proxy
 * @property expiresOn The expiration time of short lived proxy name in unix epoch.
 * @property proxy The short lived proxy name.
 */
public data class ListEndpointManagedProxyDetailsResult(
    public val expiresOn: Double,
    public val proxy: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridconnectivity.outputs.ListEndpointManagedProxyDetailsResult):
            ListEndpointManagedProxyDetailsResult = ListEndpointManagedProxyDetailsResult(
            expiresOn = javaType.expiresOn(),
            proxy = javaType.proxy(),
        )
    }
}
