@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin

import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.AgentPoolProvisioningStatusResponseStatus
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.AgentPoolResponseExtendedLocation
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.CloudProviderProfileResponse
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.AgentPoolProvisioningStatusResponseStatus.Companion.toKotlin as agentPoolProvisioningStatusResponseStatusToKotlin
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.AgentPoolResponseExtendedLocation.Companion.toKotlin as agentPoolResponseExtendedLocationToKotlin
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.CloudProviderProfileResponse.Companion.toKotlin as cloudProviderProfileResponseToKotlin
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AgentPool].
 */
@PulumiTagMarker
public class AgentPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AgentPoolArgs = AgentPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AgentPoolArgsBuilder.() -> Unit) {
        val builder = AgentPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AgentPool {
        val builtJavaResource =
            com.pulumi.azurenative.hybridcontainerservice.AgentPool(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AgentPool(builtJavaResource)
    }
}

/**
 * The agentPool resource definition
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * ## Example Usage
 * ### PutAgentPool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.HybridContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "test-hybridaksnodepool",
 *         Count = 1,
 *         Location = "westus",
 *         OsType = "Linux",
 *         ResourceGroupName = "test-arcappliance-resgrp",
 *         ResourceName = "test-hybridakscluster",
 *         VmSize = "Standard_A4_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcontainerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcontainerservice.NewAgentPool(ctx, "agentPool", &hybridcontainerservice.AgentPoolArgs{
 * 			AgentPoolName:     pulumi.String("test-hybridaksnodepool"),
 * 			Count:             pulumi.Int(1),
 * 			Location:          pulumi.String("westus"),
 * 			OsType:            pulumi.String("Linux"),
 * 			ResourceGroupName: pulumi.String("test-arcappliance-resgrp"),
 * 			ResourceName:      pulumi.String("test-hybridakscluster"),
 * 			VmSize:            pulumi.String("Standard_A4_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcontainerservice.AgentPool;
 * import com.pulumi.azurenative.hybridcontainerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("test-hybridaksnodepool")
 *             .count(1)
 *             .location("westus")
 *             .osType("Linux")
 *             .resourceGroupName("test-arcappliance-resgrp")
 *             .resourceName("test-hybridakscluster")
 *             .vmSize("Standard_A4_v2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcontainerservice:AgentPool test-hybridaksnodepool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/provisionedClusters/{resourceName}/agentPools/{agentPoolName}
 * ```
 */
public class AgentPool internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridcontainerservice.AgentPool,
) : KotlinCustomResource(javaResource, AgentPoolMapper) {
    /**
     * AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
     */
    public val availabilityZones: Output<List<String>>?
        get() = javaResource.availabilityZones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The underlying cloud infra provider properties.
     */
    public val cloudProviderProfile: Output<CloudProviderProfileResponse>?
        get() = javaResource.cloudProviderProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> cloudProviderProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
     */
    public val count: Output<Int>?
        get() = javaResource.count().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val extendedLocation: Output<AgentPoolResponseExtendedLocation>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> agentPoolResponseExtendedLocationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The maximum number of nodes for auto-scaling
     */
    public val maxCount: Output<Int>?
        get() = javaResource.maxCount().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The maximum number of pods that can run on a node.
     */
    public val maxPods: Output<Int>?
        get() = javaResource.maxPods().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The minimum number of nodes for auto-scaling
     */
    public val minCount: Output<Int>?
        get() = javaResource.minCount().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'LB', 'User'. Default is 'User'
     */
    public val mode: Output<String>?
        get() = javaResource.mode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The version of node image
     */
    public val nodeImageVersion: Output<String>?
        get() = javaResource.nodeImageVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
     */
    public val nodeLabels: Output<Map<String, String>>?
        get() = javaResource.nodeLabels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    public val nodeTaints: Output<List<String>>?
        get() = javaResource.nodeTaints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
     */
    public val osType: Output<String>?
        get() = javaResource.osType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * HybridAKSNodePoolStatus defines the observed state of HybridAKSNodePool
     */
    public val status: Output<AgentPoolProvisioningStatusResponseStatus>?
        get() = javaResource.status().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    agentPoolProvisioningStatusResponseStatusToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * VmSize - The size of the agent pool VMs.
     */
    public val vmSize: Output<String>?
        get() = javaResource.vmSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AgentPoolMapper : ResourceMapper<AgentPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridcontainerservice.AgentPool::class == javaResource::class

    override fun map(javaResource: Resource): AgentPool = AgentPool(
        javaResource as
            com.pulumi.azurenative.hybridcontainerservice.AgentPool,
    )
}

/**
 * @see [AgentPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AgentPool].
 */
public suspend fun agentPool(name: String, block: suspend AgentPoolResourceBuilder.() -> Unit):
    AgentPool {
    val builder = AgentPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AgentPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun agentPool(name: String): AgentPool {
    val builder = AgentPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
