@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin

import com.pulumi.azurenative.hybridcontainerservice.HybridcontainerserviceFunctions.getAgentPoolPlain
import com.pulumi.azurenative.hybridcontainerservice.HybridcontainerserviceFunctions.getHybridIdentityMetadatumPlain
import com.pulumi.azurenative.hybridcontainerservice.HybridcontainerserviceFunctions.getProvisionedClusterPlain
import com.pulumi.azurenative.hybridcontainerservice.HybridcontainerserviceFunctions.getStorageSpaceRetrievePlain
import com.pulumi.azurenative.hybridcontainerservice.HybridcontainerserviceFunctions.getVirtualNetworkRetrievePlain
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.GetAgentPoolPlainArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.GetAgentPoolPlainArgsBuilder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.GetHybridIdentityMetadatumPlainArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.GetHybridIdentityMetadatumPlainArgsBuilder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.GetProvisionedClusterPlainArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.GetProvisionedClusterPlainArgsBuilder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.GetStorageSpaceRetrievePlainArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.GetStorageSpaceRetrievePlainArgsBuilder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.GetVirtualNetworkRetrievePlainArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.GetVirtualNetworkRetrievePlainArgsBuilder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.GetAgentPoolResult
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.GetHybridIdentityMetadatumResult
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.GetProvisionedClusterResult
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.GetStorageSpaceRetrieveResult
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.GetVirtualNetworkRetrieveResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.GetAgentPoolResult.Companion.toKotlin as getAgentPoolResultToKotlin
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.GetHybridIdentityMetadatumResult.Companion.toKotlin as getHybridIdentityMetadatumResultToKotlin
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.GetProvisionedClusterResult.Companion.toKotlin as getProvisionedClusterResultToKotlin
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.GetStorageSpaceRetrieveResult.Companion.toKotlin as getStorageSpaceRetrieveResultToKotlin
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.GetVirtualNetworkRetrieveResult.Companion.toKotlin as getVirtualNetworkRetrieveResultToKotlin

public object HybridcontainerserviceFunctions {
    /**
     * Gets the agent pool in the Hybrid AKS provisioned cluster
     * Azure REST API version: 2022-09-01-preview.
     * @param argument null
     * @return The agentPool resource definition
     */
    public suspend fun getAgentPool(argument: GetAgentPoolPlainArgs): GetAgentPoolResult =
        getAgentPoolResultToKotlin(getAgentPoolPlain(argument.toJava()).await())

    /**
     * @see [getAgentPool].
     * @param agentPoolName Parameter for the name of the agent pool in the provisioned cluster
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName Parameter for the name of the provisioned cluster
     * @return The agentPool resource definition
     */
    public suspend fun getAgentPool(
        agentPoolName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetAgentPoolResult {
        val argument = GetAgentPoolPlainArgs(
            agentPoolName = agentPoolName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getAgentPoolResultToKotlin(getAgentPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getAgentPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridcontainerservice&#46;kotlin&#46;inputs&#46;GetAgentPoolPlainArgs].
     * @return The agentPool resource definition
     */
    public suspend fun getAgentPool(argument: suspend GetAgentPoolPlainArgsBuilder.() -> Unit):
        GetAgentPoolResult {
        val builder = GetAgentPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAgentPoolResultToKotlin(getAgentPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the hybrid identity metadata proxy resource.
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2022-05-01-preview, 2023-11-15-preview.
     * @param argument null
     * @return Defines the hybridIdentityMetadata.
     */
    public suspend fun getHybridIdentityMetadatum(argument: GetHybridIdentityMetadatumPlainArgs):
        GetHybridIdentityMetadatumResult =
        getHybridIdentityMetadatumResultToKotlin(getHybridIdentityMetadatumPlain(argument.toJava()).await())

    /**
     * @see [getHybridIdentityMetadatum].
     * @param hybridIdentityMetadataResourceName Parameter for the name of the hybrid identity metadata resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName Parameter for the name of the provisioned cluster
     * @return Defines the hybridIdentityMetadata.
     */
    public suspend fun getHybridIdentityMetadatum(
        hybridIdentityMetadataResourceName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetHybridIdentityMetadatumResult {
        val argument = GetHybridIdentityMetadatumPlainArgs(
            hybridIdentityMetadataResourceName = hybridIdentityMetadataResourceName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getHybridIdentityMetadatumResultToKotlin(getHybridIdentityMetadatumPlain(argument.toJava()).await())
    }

    /**
     * @see [getHybridIdentityMetadatum].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridcontainerservice&#46;kotlin&#46;inputs&#46;GetHybridIdentityMetadatumPlainArgs].
     * @return Defines the hybridIdentityMetadata.
     */
    public suspend
    fun getHybridIdentityMetadatum(argument: suspend GetHybridIdentityMetadatumPlainArgsBuilder.() -> Unit):
        GetHybridIdentityMetadatumResult {
        val builder = GetHybridIdentityMetadatumPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHybridIdentityMetadatumResultToKotlin(getHybridIdentityMetadatumPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Hybrid AKS provisioned cluster
     * Azure REST API version: 2022-09-01-preview.
     * Other available API versions: 2022-05-01-preview.
     * @param argument null
     * @return The provisionedClusters resource definition.
     */
    public suspend fun getProvisionedCluster(argument: GetProvisionedClusterPlainArgs):
        GetProvisionedClusterResult =
        getProvisionedClusterResultToKotlin(getProvisionedClusterPlain(argument.toJava()).await())

    /**
     * @see [getProvisionedCluster].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName Parameter for the name of the provisioned cluster
     * @return The provisionedClusters resource definition.
     */
    public suspend fun getProvisionedCluster(resourceGroupName: String, resourceName: String):
        GetProvisionedClusterResult {
        val argument = GetProvisionedClusterPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getProvisionedClusterResultToKotlin(getProvisionedClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getProvisionedCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridcontainerservice&#46;kotlin&#46;inputs&#46;GetProvisionedClusterPlainArgs].
     * @return The provisionedClusters resource definition.
     */
    public suspend
    fun getProvisionedCluster(argument: suspend GetProvisionedClusterPlainArgsBuilder.() -> Unit):
        GetProvisionedClusterResult {
        val builder = GetProvisionedClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProvisionedClusterResultToKotlin(getProvisionedClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Hybrid AKS storage space object
     * Azure REST API version: 2022-09-01-preview.
     * @param argument null
     * @return The storageSpaces resource definition.
     */
    public suspend fun getStorageSpaceRetrieve(argument: GetStorageSpaceRetrievePlainArgs):
        GetStorageSpaceRetrieveResult =
        getStorageSpaceRetrieveResultToKotlin(getStorageSpaceRetrievePlain(argument.toJava()).await())

    /**
     * @see [getStorageSpaceRetrieve].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param storageSpacesName Parameter for the name of the storage object
     * @return The storageSpaces resource definition.
     */
    public suspend fun getStorageSpaceRetrieve(resourceGroupName: String, storageSpacesName: String):
        GetStorageSpaceRetrieveResult {
        val argument = GetStorageSpaceRetrievePlainArgs(
            resourceGroupName = resourceGroupName,
            storageSpacesName = storageSpacesName,
        )
        return getStorageSpaceRetrieveResultToKotlin(getStorageSpaceRetrievePlain(argument.toJava()).await())
    }

    /**
     * @see [getStorageSpaceRetrieve].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridcontainerservice&#46;kotlin&#46;inputs&#46;GetStorageSpaceRetrievePlainArgs].
     * @return The storageSpaces resource definition.
     */
    public suspend
    fun getStorageSpaceRetrieve(argument: suspend GetStorageSpaceRetrievePlainArgsBuilder.() -> Unit):
        GetStorageSpaceRetrieveResult {
        val builder = GetStorageSpaceRetrievePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStorageSpaceRetrieveResultToKotlin(getStorageSpaceRetrievePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Hybrid AKS virtual network
     * Azure REST API version: 2022-09-01-preview.
     * @param argument null
     * @return The virtualNetworks resource definition.
     */
    public suspend fun getVirtualNetworkRetrieve(argument: GetVirtualNetworkRetrievePlainArgs):
        GetVirtualNetworkRetrieveResult =
        getVirtualNetworkRetrieveResultToKotlin(getVirtualNetworkRetrievePlain(argument.toJava()).await())

    /**
     * @see [getVirtualNetworkRetrieve].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param virtualNetworksName Parameter for the name of the virtual network
     * @return The virtualNetworks resource definition.
     */
    public suspend fun getVirtualNetworkRetrieve(
        resourceGroupName: String,
        virtualNetworksName: String,
    ): GetVirtualNetworkRetrieveResult {
        val argument = GetVirtualNetworkRetrievePlainArgs(
            resourceGroupName = resourceGroupName,
            virtualNetworksName = virtualNetworksName,
        )
        return getVirtualNetworkRetrieveResultToKotlin(getVirtualNetworkRetrievePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualNetworkRetrieve].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridcontainerservice&#46;kotlin&#46;inputs&#46;GetVirtualNetworkRetrievePlainArgs].
     * @return The virtualNetworks resource definition.
     */
    public suspend
    fun getVirtualNetworkRetrieve(argument: suspend GetVirtualNetworkRetrievePlainArgsBuilder.() -> Unit):
        GetVirtualNetworkRetrieveResult {
        val builder = GetVirtualNetworkRetrievePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualNetworkRetrieveResultToKotlin(getVirtualNetworkRetrievePlain(builtArgument.toJava()).await())
    }
}
