@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.AADProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * AAD Profile specifies attributes for Azure Active Directory integration.
 * @property adminGroupObjectIDs The list of AAD group object IDs that will have admin role of the cluster.
 * @property clientAppID The client AAD application ID.
 * @property enableAzureRbac Whether to enable Azure RBAC for Kubernetes authorization.
 * @property managed Whether to enable managed AAD.
 * @property serverAppID The server AAD application ID.
 * @property serverAppSecret The server AAD application secret.
 * @property tenantID The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
 */
public data class AADProfileArgs(
    public val adminGroupObjectIDs: Output<List<String>>? = null,
    public val clientAppID: Output<String>? = null,
    public val enableAzureRbac: Output<Boolean>? = null,
    public val managed: Output<Boolean>? = null,
    public val serverAppID: Output<String>? = null,
    public val serverAppSecret: Output<String>? = null,
    public val tenantID: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.AADProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.inputs.AADProfileArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.AADProfileArgs.builder()
            .adminGroupObjectIDs(adminGroupObjectIDs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clientAppID(clientAppID?.applyValue({ args0 -> args0 }))
            .enableAzureRbac(enableAzureRbac?.applyValue({ args0 -> args0 }))
            .managed(managed?.applyValue({ args0 -> args0 }))
            .serverAppID(serverAppID?.applyValue({ args0 -> args0 }))
            .serverAppSecret(serverAppSecret?.applyValue({ args0 -> args0 }))
            .tenantID(tenantID?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AADProfileArgs].
 */
@PulumiTagMarker
public class AADProfileArgsBuilder internal constructor() {
    private var adminGroupObjectIDs: Output<List<String>>? = null

    private var clientAppID: Output<String>? = null

    private var enableAzureRbac: Output<Boolean>? = null

    private var managed: Output<Boolean>? = null

    private var serverAppID: Output<String>? = null

    private var serverAppSecret: Output<String>? = null

    private var tenantID: Output<String>? = null

    /**
     * @param value The list of AAD group object IDs that will have admin role of the cluster.
     */
    @JvmName("ltlvufdgkqnhibkl")
    public suspend fun adminGroupObjectIDs(`value`: Output<List<String>>) {
        this.adminGroupObjectIDs = value
    }

    @JvmName("rasjfpbpiuxxvxmb")
    public suspend fun adminGroupObjectIDs(vararg values: Output<String>) {
        this.adminGroupObjectIDs = Output.all(values.asList())
    }

    /**
     * @param values The list of AAD group object IDs that will have admin role of the cluster.
     */
    @JvmName("ypdxvruyqspcqhjb")
    public suspend fun adminGroupObjectIDs(values: List<Output<String>>) {
        this.adminGroupObjectIDs = Output.all(values)
    }

    /**
     * @param value The client AAD application ID.
     */
    @JvmName("ksvabccjaueqfchy")
    public suspend fun clientAppID(`value`: Output<String>) {
        this.clientAppID = value
    }

    /**
     * @param value Whether to enable Azure RBAC for Kubernetes authorization.
     */
    @JvmName("tkxjhbyosdsgnndj")
    public suspend fun enableAzureRbac(`value`: Output<Boolean>) {
        this.enableAzureRbac = value
    }

    /**
     * @param value Whether to enable managed AAD.
     */
    @JvmName("whmujsxtmvkcdoxq")
    public suspend fun managed(`value`: Output<Boolean>) {
        this.managed = value
    }

    /**
     * @param value The server AAD application ID.
     */
    @JvmName("cihqvvtgvquwtwnl")
    public suspend fun serverAppID(`value`: Output<String>) {
        this.serverAppID = value
    }

    /**
     * @param value The server AAD application secret.
     */
    @JvmName("rfrviigmabgupffs")
    public suspend fun serverAppSecret(`value`: Output<String>) {
        this.serverAppSecret = value
    }

    /**
     * @param value The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
     */
    @JvmName("bftirmeqimxamfxm")
    public suspend fun tenantID(`value`: Output<String>) {
        this.tenantID = value
    }

    /**
     * @param value The list of AAD group object IDs that will have admin role of the cluster.
     */
    @JvmName("xutotqmyoifuaowl")
    public suspend fun adminGroupObjectIDs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminGroupObjectIDs = mapped
    }

    /**
     * @param values The list of AAD group object IDs that will have admin role of the cluster.
     */
    @JvmName("wqttjgmgwntfjsvs")
    public suspend fun adminGroupObjectIDs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminGroupObjectIDs = mapped
    }

    /**
     * @param value The client AAD application ID.
     */
    @JvmName("ndpfnuxtwtgtwnjy")
    public suspend fun clientAppID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAppID = mapped
    }

    /**
     * @param value Whether to enable Azure RBAC for Kubernetes authorization.
     */
    @JvmName("tauygdeikdhnvrly")
    public suspend fun enableAzureRbac(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAzureRbac = mapped
    }

    /**
     * @param value Whether to enable managed AAD.
     */
    @JvmName("gviwvbqnlcbcwosk")
    public suspend fun managed(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managed = mapped
    }

    /**
     * @param value The server AAD application ID.
     */
    @JvmName("vnefkmrqxgoyuvic")
    public suspend fun serverAppID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverAppID = mapped
    }

    /**
     * @param value The server AAD application secret.
     */
    @JvmName("tmhmmtmgvetbxybq")
    public suspend fun serverAppSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverAppSecret = mapped
    }

    /**
     * @param value The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
     */
    @JvmName("ftkvaindecbbjeqy")
    public suspend fun tenantID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantID = mapped
    }

    internal fun build(): AADProfileArgs = AADProfileArgs(
        adminGroupObjectIDs = adminGroupObjectIDs,
        clientAppID = clientAppID,
        enableAzureRbac = enableAzureRbac,
        managed = managed,
        serverAppID = serverAppID,
        serverAppSecret = serverAppSecret,
        tenantID = tenantID,
    )
}
