@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileInfraNetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * InfraNetworkProfile - List of infra network profiles for the provisioned cluster
 * @property vnetSubnetIds Array of references to azure resource corresponding to the new HybridAKSNetwork object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/virtualNetworks/{virtualNetworkName}
 */
public data class CloudProviderProfileInfraNetworkProfileArgs(
    public val vnetSubnetIds: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileInfraNetworkProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileInfraNetworkProfileArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileInfraNetworkProfileArgs.builder()
            .vnetSubnetIds(vnetSubnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CloudProviderProfileInfraNetworkProfileArgs].
 */
@PulumiTagMarker
public class CloudProviderProfileInfraNetworkProfileArgsBuilder internal constructor() {
    private var vnetSubnetIds: Output<List<String>>? = null

    /**
     * @param value Array of references to azure resource corresponding to the new HybridAKSNetwork object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/virtualNetworks/{virtualNetworkName}
     */
    @JvmName("sgwubbpheliyhobw")
    public suspend fun vnetSubnetIds(`value`: Output<List<String>>) {
        this.vnetSubnetIds = value
    }

    @JvmName("pxppomjeovyoadvn")
    public suspend fun vnetSubnetIds(vararg values: Output<String>) {
        this.vnetSubnetIds = Output.all(values.asList())
    }

    /**
     * @param values Array of references to azure resource corresponding to the new HybridAKSNetwork object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/virtualNetworks/{virtualNetworkName}
     */
    @JvmName("kuawicfclqnggjhv")
    public suspend fun vnetSubnetIds(values: List<Output<String>>) {
        this.vnetSubnetIds = Output.all(values)
    }

    /**
     * @param value Array of references to azure resource corresponding to the new HybridAKSNetwork object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/virtualNetworks/{virtualNetworkName}
     */
    @JvmName("rubgogpwutahpnjj")
    public suspend fun vnetSubnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetSubnetIds = mapped
    }

    /**
     * @param values Array of references to azure resource corresponding to the new HybridAKSNetwork object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/virtualNetworks/{virtualNetworkName}
     */
    @JvmName("xunbetpiixjwlfma")
    public suspend fun vnetSubnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vnetSubnetIds = mapped
    }

    internal fun build(): CloudProviderProfileInfraNetworkProfileArgs =
        CloudProviderProfileInfraNetworkProfileArgs(
            vnetSubnetIds = vnetSubnetIds,
        )
}
