@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersCommonPropertiesFeaturesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Additional features specs like Arc Agent Onboarding.
 * @property arcAgentProfile Arc agentry configuration for the provisioned cluster.
 */
public data class ProvisionedClustersCommonPropertiesFeaturesArgs(
    public val arcAgentProfile: Output<ArcAgentProfileArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersCommonPropertiesFeaturesArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersCommonPropertiesFeaturesArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersCommonPropertiesFeaturesArgs.builder()
            .arcAgentProfile(
                arcAgentProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ProvisionedClustersCommonPropertiesFeaturesArgs].
 */
@PulumiTagMarker
public class ProvisionedClustersCommonPropertiesFeaturesArgsBuilder internal constructor() {
    private var arcAgentProfile: Output<ArcAgentProfileArgs>? = null

    /**
     * @param value Arc agentry configuration for the provisioned cluster.
     */
    @JvmName("yrkovnlbrlngmpri")
    public suspend fun arcAgentProfile(`value`: Output<ArcAgentProfileArgs>) {
        this.arcAgentProfile = value
    }

    /**
     * @param value Arc agentry configuration for the provisioned cluster.
     */
    @JvmName("xsrrwwotnpbaiglb")
    public suspend fun arcAgentProfile(`value`: ArcAgentProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arcAgentProfile = mapped
    }

    /**
     * @param argument Arc agentry configuration for the provisioned cluster.
     */
    @JvmName("meakduotjokriwca")
    public suspend fun arcAgentProfile(argument: suspend ArcAgentProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ArcAgentProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.arcAgentProfile = mapped
    }

    internal fun build(): ProvisionedClustersCommonPropertiesFeaturesArgs =
        ProvisionedClustersCommonPropertiesFeaturesArgs(
            arcAgentProfile = arcAgentProfile,
        )
}
