@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesStatusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * HybridAKSStorageStatus defines the observed state of HybridAKSStorage
 * @property provisioningStatus Contains Provisioning errors
 */
public data class StorageSpacesPropertiesStatusArgs(
    public val provisioningStatus: Output<StorageSpacesPropertiesProvisioningStatusArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesStatusArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesStatusArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesStatusArgs.builder()
            .provisioningStatus(
                provisioningStatus?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [StorageSpacesPropertiesStatusArgs].
 */
@PulumiTagMarker
public class StorageSpacesPropertiesStatusArgsBuilder internal constructor() {
    private var provisioningStatus: Output<StorageSpacesPropertiesProvisioningStatusArgs>? = null

    /**
     * @param value Contains Provisioning errors
     */
    @JvmName("vfvjlidcrkejeqnb")
    public suspend
    fun provisioningStatus(`value`: Output<StorageSpacesPropertiesProvisioningStatusArgs>) {
        this.provisioningStatus = value
    }

    /**
     * @param value Contains Provisioning errors
     */
    @JvmName("jfowdargucigkafx")
    public suspend fun provisioningStatus(`value`: StorageSpacesPropertiesProvisioningStatusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningStatus = mapped
    }

    /**
     * @param argument Contains Provisioning errors
     */
    @JvmName("ommgldgfgybekakn")
    public suspend
    fun provisioningStatus(argument: suspend StorageSpacesPropertiesProvisioningStatusArgsBuilder.() -> Unit) {
        val toBeMapped = StorageSpacesPropertiesProvisioningStatusArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.provisioningStatus = mapped
    }

    internal fun build(): StorageSpacesPropertiesStatusArgs = StorageSpacesPropertiesStatusArgs(
        provisioningStatus = provisioningStatus,
    )
}
