@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesInfraVnetProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property hci Infra network profile for HCI platform
 * @property networkCloud Infra network profile for the NetworkCloud platform
 * @property vmware Infra network profile for VMware platform
 */
public data class VirtualNetworksPropertiesInfraVnetProfileArgs(
    public val hci: Output<VirtualNetworksPropertiesHciArgs>? = null,
    public val networkCloud: Output<VirtualNetworksPropertiesNetworkCloudArgs>? = null,
    public val vmware: Output<VirtualNetworksPropertiesVmwareArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesInfraVnetProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesInfraVnetProfileArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesInfraVnetProfileArgs.builder()
            .hci(hci?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkCloud(networkCloud?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vmware(vmware?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNetworksPropertiesInfraVnetProfileArgs].
 */
@PulumiTagMarker
public class VirtualNetworksPropertiesInfraVnetProfileArgsBuilder internal constructor() {
    private var hci: Output<VirtualNetworksPropertiesHciArgs>? = null

    private var networkCloud: Output<VirtualNetworksPropertiesNetworkCloudArgs>? = null

    private var vmware: Output<VirtualNetworksPropertiesVmwareArgs>? = null

    /**
     * @param value Infra network profile for HCI platform
     */
    @JvmName("umcamrknudajkprq")
    public suspend fun hci(`value`: Output<VirtualNetworksPropertiesHciArgs>) {
        this.hci = value
    }

    /**
     * @param value Infra network profile for the NetworkCloud platform
     */
    @JvmName("paunbvpmkdxypquk")
    public suspend fun networkCloud(`value`: Output<VirtualNetworksPropertiesNetworkCloudArgs>) {
        this.networkCloud = value
    }

    /**
     * @param value Infra network profile for VMware platform
     */
    @JvmName("ggewcjjigyrjajtq")
    public suspend fun vmware(`value`: Output<VirtualNetworksPropertiesVmwareArgs>) {
        this.vmware = value
    }

    /**
     * @param value Infra network profile for HCI platform
     */
    @JvmName("nfqfuopoxfxptkgq")
    public suspend fun hci(`value`: VirtualNetworksPropertiesHciArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hci = mapped
    }

    /**
     * @param argument Infra network profile for HCI platform
     */
    @JvmName("rmpcjepdgkmctwiy")
    public suspend fun hci(argument: suspend VirtualNetworksPropertiesHciArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworksPropertiesHciArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hci = mapped
    }

    /**
     * @param value Infra network profile for the NetworkCloud platform
     */
    @JvmName("trnwimxbnrpkhvls")
    public suspend fun networkCloud(`value`: VirtualNetworksPropertiesNetworkCloudArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkCloud = mapped
    }

    /**
     * @param argument Infra network profile for the NetworkCloud platform
     */
    @JvmName("awlhpovoulamhdqr")
    public suspend
    fun networkCloud(argument: suspend VirtualNetworksPropertiesNetworkCloudArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworksPropertiesNetworkCloudArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkCloud = mapped
    }

    /**
     * @param value Infra network profile for VMware platform
     */
    @JvmName("qhsvvquiddurlcso")
    public suspend fun vmware(`value`: VirtualNetworksPropertiesVmwareArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmware = mapped
    }

    /**
     * @param argument Infra network profile for VMware platform
     */
    @JvmName("gpcwxbjjqlyhaonr")
    public suspend
    fun vmware(argument: suspend VirtualNetworksPropertiesVmwareArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworksPropertiesVmwareArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vmware = mapped
    }

    internal fun build(): VirtualNetworksPropertiesInfraVnetProfileArgs =
        VirtualNetworksPropertiesInfraVnetProfileArgs(
            hci = hci,
            networkCloud = networkCloud,
            vmware = vmware,
        )
}
