@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * HybridAKSNodePoolStatus defines the observed state of HybridAKSNodePool
 * @property errorMessage ErrorMessage - Error messages during creation of cluster
 * @property provisioningStatus Contains Provisioning errors
 * @property readyReplicas Total number of ready machines targeted by this deployment.
 * @property replicas Total number of non-terminated machines targeted by this deployment
 */
public data class AgentPoolProvisioningStatusResponseStatus(
    public val errorMessage: String? = null,
    public val provisioningStatus: AgentPoolProvisioningStatusResponseProvisioningStatus? = null,
    public val readyReplicas: Int? = null,
    public val replicas: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.AgentPoolProvisioningStatusResponseStatus):
            AgentPoolProvisioningStatusResponseStatus = AgentPoolProvisioningStatusResponseStatus(
            errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
            provisioningStatus = javaType.provisioningStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.AgentPoolProvisioningStatusResponseProvisioningStatus.Companion.toKotlin(args0)
                })
            }).orElse(null),
            readyReplicas = javaType.readyReplicas().map({ args0 -> args0 }).orElse(null),
            replicas = javaType.replicas().map({ args0 -> args0 }).orElse(null),
        )
    }
}
