@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * LinuxProfile - Profile for Linux VMs in the container service cluster.
 * @property adminUsername AdminUsername - The administrator username to use for Linux VMs.
 * @property ssh SSH - SSH configuration for Linux-based VMs running on Azure.
 */
public data class LinuxProfilePropertiesResponse(
    public val adminUsername: String? = null,
    public val ssh: LinuxProfilePropertiesResponseSsh? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.LinuxProfilePropertiesResponse):
            LinuxProfilePropertiesResponse = LinuxProfilePropertiesResponse(
            adminUsername = javaType.adminUsername().map({ args0 -> args0 }).orElse(null),
            ssh = javaType.ssh().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.LinuxProfilePropertiesResponseSsh.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
